<?php

namespace Drop\Oms\Observer\Sales;

use Drop\Oms\Block\Checkout\Address\Fields\ShippingLayoutProcessor;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\QuoteRepository;
use Magento\Sales\Model\Order;
use Psr\Log\LoggerInterface;

class QuoteSubmitBefore implements ObserverInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var QuoteRepository
     */
    private $quoteRepository;

    /**
     * QuoteSubmitBefore constructor.
     * @param QuoteRepository $quoteRepository
     * @param LoggerInterface $logger
     */
    public function __construct(
        QuoteRepository $quoteRepository,
        LoggerInterface  $logger
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->logger = $logger; // @todo: custom logger
    }

    public function execute(
        Observer $observer
    ) {
        /** @var Order $order */
        $order = $observer->getOrder();
        $quote = $this->quoteRepository->get($order->getQuoteId());

        try {
            $this->orderAddressFields($order, $quote);
            $this->orderAddressFields($order, $quote, false);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }
    }

    /**
     * Override billing with shipping information (show invoice request only on shipping address )
     * @param $order
     * @param $quote
     * @param $isTypeBilling
     * @return $this
     */
    private function orderAddressFields($order, $quote, $isTypeBilling = true)
    {
        $address = $isTypeBilling ? $order->getBillingAddress() : $order->getShippingAddress();

        if(!$address || !$quote->getShippingAddress()) {
            return $this;
        }

        $address->setData(
            ShippingLayoutProcessor::CUSTOMER_TYPOLOGY,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::CUSTOMER_TYPOLOGY)
        );
        $address->setData(
            ShippingLayoutProcessor::REQUEST_INVOICE,
            $quote->getShippingAddress()->getData(ShippingLayoutProcessor::REQUEST_INVOICE)
        );
        $address->setData(
            ShippingLayoutProcessor::FISCAL_CODE,
            $this->clearData(ShippingLayoutProcessor::FISCAL_CODE, $quote->getShippingAddress())
        );
        $address->setData(
            ShippingLayoutProcessor::RECEPTION_DESTINATION,
            $this->clearData(ShippingLayoutProcessor::RECEPTION_DESTINATION, $quote->getShippingAddress())

        )->save();

        return $this;
    }

    /**
     * @param $field
     * @param $address
     * @return mixed
     */
    private function clearData($field, $address)
    {
        return $address->getData($field);
    }
}
