<?php

namespace Drop\Oms\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Customer\Setup\CustomerSetupFactory;
use Magento\Quote\Setup\QuoteSetup;
use Magento\Quote\Setup\QuoteSetupFactory;
use Magento\Sales\Setup\SalesSetup;
use Magento\Sales\Setup\SalesSetupFactory;
use Magento\Customer\Api\AddressMetadataInterface;

/**
 * Class InstallData
 * @package Eadesigndev\Checkoutaddressfields\Setup
 */
class InstallData implements InstallDataInterface
{
    /**
     * @var CustomerSetupFactory
     */
    private $customerSetupFactory;

    /**
     * @var SalesSetupFactory
     */
    private $salesSetupFactory;

    /**
     * @var QuoteSetupFactory
     */
    private $quoteSetupFactory;

    /**
     * InstallData constructor.
     * @param CustomerSetupFactory $customerSetupFactory
     * @param SalesSetupFactory $salesSetupFactory
     * @param QuoteSetupFactory $quoteSetupFactory
     */
    public function __construct(
        CustomerSetupFactory $customerSetupFactory,
        SalesSetupFactory $salesSetupFactory,
        QuoteSetupFactory $quoteSetupFactory
    ) {
        $this->customerSetupFactory = $customerSetupFactory;
        $this->salesSetupFactory = $salesSetupFactory;
        $this->quoteSetupFactory = $quoteSetupFactory;
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context) {
        $customerSetup = $this->customerSetupFactory->create(['setup' => $setup]);

        /**
         * Add Customer address attributes to eav_attribute
         */
        $customerSetup->addAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'request_invoice', [
            'label' => 'Request Invoice',
            'input' => 'boolean',
            'type' => 'int',
            'default' => 0,
            'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
            'required' => false,
            'position' => 150,
            'visible' => true,
            'system' => false,
            'is_used_in_grid' => false,
            'is_visible_in_grid' => false,
            'is_filterable_in_grid' => false,
            'is_searchable_in_grid' => false,
            'backend' => ''
        ]);

        $customerSetup->addAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'customer_typology', [
            'label' => 'Customer Typology',
            'input' => 'boolean',
            'type' => 'int',
            'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
            'required' => false,
            'default' => 0,
            'position' => 160,
            'visible' => true,
            'system' => false,
            'is_used_in_grid' => false,
            'is_visible_in_grid' => false,
            'is_filterable_in_grid' => false,
            'is_searchable_in_grid' => false,
            'backend' => ''
        ]);

        $customerSetup->addAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'fiscal_code', [
            'label' => 'Fiscal Code',
            'input' => 'text',
            'type' => 'varchar',
            'source' => '',
            'required' => false,
            'position' => 170,
            'visible' => true,
            'system' => false,
            'is_used_in_grid' => false,
            'is_visible_in_grid' => false,
            'is_filterable_in_grid' => false,
            'is_searchable_in_grid' => false,
            'backend' => ''
        ]);

        $customerSetup->addAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'fe_reception_destination', [
            'label' => 'Reception Destination',
            'input' => 'text',
            'type' => 'varchar',
            'source' => '',
            'required' => false,
            'position' => 190,
            'visible' => true,
            'system' => false,
            'is_used_in_grid' => false,
            'is_visible_in_grid' => false,
            'is_filterable_in_grid' => false,
            'is_searchable_in_grid' => false,
            'backend' => ''
        ]);

        /**
         * Set new customer address attributes form
         */
        $attribute = $customerSetup->getEavConfig()->getAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'request_invoice')
            ->addData(['used_in_forms' => [
                'adminhtml_customer_address',
                'customer_address_edit',
                'customer_register_address'
            ]]);
        $attribute->save();

        $attribute = $customerSetup->getEavConfig()->getAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'customer_typology')
            ->addData(['used_in_forms' => [
                'adminhtml_customer_address',
                'customer_address_edit',
                'customer_register_address'
            ]]);
        $attribute->save();

        $attribute = $customerSetup->getEavConfig()->getAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'fiscal_code')
            ->addData(['used_in_forms' => [
                'adminhtml_customer_address',
                'customer_address_edit',
                'customer_register_address'
            ]]);
        $attribute->save();

        $attribute = $customerSetup->getEavConfig()->getAttribute(AddressMetadataInterface::ENTITY_TYPE_ADDRESS, 'fe_reception_destination')
            ->addData(['used_in_forms' => [
                'adminhtml_customer_address',
                'customer_address_edit',
                'customer_register_address'
            ]]);
        $attribute->save();


        $installer = $setup;

        /**
         * Add columns to Quote Address
         */
        $installer->getConnection()->addColumn(
            $installer->getTable('quote_address'),
            'customer_typology',
            [
                'comment' => 'Customer Tipology (Private or Company)',
                'type' => Table::TYPE_BOOLEAN,
                'length' => 255
            ]
        );

        $installer->getConnection()->addColumn(
            $installer->getTable('quote_address'),
            'request_invoice',
            [
                'comment' => 'Request invoice',
                'type' =>  Table::TYPE_BOOLEAN,
                'length' => 255
            ]
        );
        $installer->getConnection()->addColumn(
            $installer->getTable('quote_address'),
            'fiscal_code',
            [
                'comment' => 'Fiscal Code',
                'type' =>  Table::TYPE_TEXT,
                'length' => 255
            ]
        );
        $installer->getConnection()->addColumn(
            $installer->getTable('quote_address'),
            'fe_reception_destination',
            [
                'comment' => 'Reception Destination',
                'type' =>  Table::TYPE_TEXT,
                'length' => 255
            ]
        );

        /**
         * Add columns to Order Address
         */
        $installer->getConnection()->addColumn(
            $installer->getTable('sales_order_address'),
            'request_invoice',
            [
                'comment' => 'Request invoice',
                'type' =>  Table::TYPE_BOOLEAN,
                'length' => 255
            ]
        );
        $installer->getConnection()->addColumn(
            $installer->getTable('sales_order_address'),
            'customer_typology',
            [
                'comment' => 'Customer Tipology (Private or Company)',
                'type' =>  Table::TYPE_BOOLEAN,
                'length' => 255
            ]
        );
        $installer->getConnection()->addColumn(
            $installer->getTable('sales_order_address'),
            'fiscal_code',
            [
                'comment' => 'Fiscal Code',
                'type' =>  Table::TYPE_TEXT,
                'length' => 255
            ]
        );
        $installer->getConnection()->addColumn(
            $installer->getTable('sales_order_address'),
            'fe_reception_destination',
            [
                'comment' => 'Reception destination',
                'type' =>  Table::TYPE_TEXT,
                'length' => 255
            ]
        );

        /**
         * Update admin fields
         */
        $installer->getConnection()->insertOnDuplicate(
            $installer->getTable('core_config_data'),
            [
                'scope' => 'default',
                'scope_id' => 0,
                'path' => 'customer/create_account/vat_frontend_visibility',
                'value' => 1
            ]
        );
        $installer->getConnection()->insertOnDuplicate(
            $installer->getTable('core_config_data'),
            [
                'scope' => 'default',
                'scope_id' => 0,
                'path' => 'customer/address/taxvat_show',
                'value' => 'opt'
            ]
        );

        $installer->getConnection()->insertOnDuplicate(
            $installer->getTable('core_config_data'),
            [
                'scope' => 'default',
                'scope_id' => 0,
                'path' => 'customer/address_templates/text',
                'value' => '{{depend prefix}}{{var prefix}} {{/depend}}{{var firstname}} {{depend middlename}}{{var middlename}} {{/depend}}{{var lastname}}{{depend suffix}} {{var suffix}}{{/depend}}
{{if street1}}{{var street1}}
{{/if}}
{{depend street2}}{{var street2}}{{/depend}}
{{depend street3}}{{var street3}}{{/depend}}
{{depend street4}}{{var street4}}{{/depend}}
{{if city}}{{var city}},  {{/if}}{{if region}}{{var region}}, {{/if}}{{if postcode}}{{var postcode}}{{/if}}
{{var country}}
{{depend telephone}}T: {{var telephone}}{{/depend}}
{{depend fax}}F: {{var fax}}{{/depend}}
IR: {{var request_invoice}}
{{depend vat_id}}VAT: {{var vat_id}}{{/depend}}
{{depend company}}{{var company}}{{/depend}}
{{depend fiscal_code}}{{var fiscal_code}}{{/depend}}
{{depend fe_reception_destination}}{{var fe_reception_destination}}{{/depend}}'
            ]
        );
        $installer->getConnection()->insertOnDuplicate(
            $installer->getTable('core_config_data'),
            [
                'scope' => 'default',
                'scope_id' => 0,
                'path' => 'customer/address_templates/html',
                'value' => '{{depend prefix}}{{var prefix}} {{/depend}}{{var firstname}} {{depend middlename}}{{var middlename}} {{/depend}}{{var lastname}}{{depend suffix}} {{var suffix}}{{/depend}}{{depend firstname}}<br />{{/depend}}
{{if street1}}{{var street1}}<br />{{/if}}
{{depend street2}}{{var street2}}<br />{{/depend}}
{{depend street3}}{{var street3}}<br />{{/depend}}
{{depend street4}}{{var street4}}<br />{{/depend}}
{{if city}}{{var city}},  {{/if}}{{if region}}{{var region}}, {{/if}}{{if postcode}}{{var postcode}}{{/if}}<br />
{{var country}}<br />
{{depend telephone}}T: <a href="tel:{{var telephone}}">{{var telephone}}</a>{{/depend}}
{{depend fax}}<br />F: {{var fax}}{{/depend}}
<br /><br />IR: {{var request_invoice}}<br />
{{depend vat_id}}VAT: {{var vat_id}}<br />{{/depend}}
{{depend company}}{{var company}}<br />{{/depend}}
{{depend fiscal_code}}{{var fiscal_code}}<br />{{/depend}}
{{depend fe_reception_destination}}{{var fe_reception_destination}}<br />{{/depend}}'
            ]
        );
        $installer->getConnection()->insertOnDuplicate(
            $installer->getTable('core_config_data'),
            [
                'scope' => 'default',
                'scope_id' => 0,
                'path' => 'customer/address_templates/pdf',
                'value' => '{{depend prefix}}{{var prefix}} {{/depend}}{{var firstname}} {{depend middlename}}{{var middlename}} {{/depend}}{{var lastname}}{{depend suffix}} {{var suffix}}{{/depend}}|
{{/depend}}
{{if street1}}{{var street1}}|{{/if}}
{{depend street2}}{{var street2}}|{{/depend}}
{{depend street3}}{{var street3}}|{{/depend}}
{{depend street4}}{{var street4}}|{{/depend}}
{{if city}}{{var city}}, {{/if}}{{if region}}{{var region}}, {{/if}}{{if postcode}}{{var postcode}}{{/if}}|
{{var country}}|
{{depend telephone}}T: {{var telephone}}|{{/depend}}
{{depend fax}}F: {{var fax}}|{{/depend}}|IR: {{var request_invoice}}|{{depend vat_id}}VAT: {{var vat_id}}{{/depend}}|{{depend company}}{{var company}}|{{depend fiscal_code}}{{var fiscal_code}}|{{depend fe_reception_destination}}{{var fe_reception_destination}}|'
            ]
        );

        /**
         * Set vat_id field not required. Will be managed via JS
         */
        $eavTable = $installer->getTable('eav_attribute');
        $installer->getConnection()->query(
            "UPDATE {$eavTable} SET `is_required` = 0 WHERE `{$eavTable}`.`attribute_id` = 36;"
        );

    }

}
