<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Drop\Oms\Controller\Validation;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class VatId extends Action
{

    const CONNECTION_TIMEOUT = 5;

    protected $jsonFactory;

    /**
     * @param Context $context
     */
    public function __construct(
        Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $jsonFactory
    ) {
        parent::__construct($context);
        $this->jsonFactory = $jsonFactory;
    }
    
    public function execute()
    {
        $vatId = $this->getRequest()->getPost('vat_id');
        $countryId = $this->getRequest()->getPost('country_id');
        if(!isset($vatId) || !isset($countryId)) {return false;}

        $response = new \Magento\Framework\DataObject();
        $response->setError(false);

        try {
            $timeout = ini_get('default_socket_timeout'); //get timeout to reverted back
            ini_set('default_socket_timeout', self::CONNECTION_TIMEOUT); //set timeout

            $time_start = microtime(true);
            $pIva = new \fdisotto\PartitaIVA($vatId, $countryId);
            if ($pIva->isValid() === false) {
                throw new \Exception(__('The VAT number does not exist.'));
            }

            $response->setHtmlMessage(__('Vat number validated successfully.'));
        } catch (\Exception $e) {
            $time_request = (microtime(true) - $time_start);
            $response->setError(true)
                ->setHtmlMessage($e->getMessage());
            if(ini_get('default_socket_timeout') < $time_request) {
                $response->setCode('timeout')->setHtmlMessage('');
            }
        }

        ini_set('default_socket_timeout', $timeout); //reverted back
        return $this->jsonFactory->create()->setJsonData($response->toJson());
    }

}
