define([
    'jquery',
    'domReady'
], function($)
{
    return function(config, element) {

        var invoiceEdit = {

            init: function() {
                this.bindCountryEvents();
                this.bindRequestInvoiceCheckbox();
                this.bindCustomerChoice();
                this.checkMandatoryInvoice();
            },

            bindCountryEvents: function(){
                $("#country").on('change', function(ev){
                    var country = $(this).val();
                    invoiceEdit.checkMandatoryInvoice(country);
                    $("#show-invoice-fields").trigger('change');
                });
            },

            bindRequestInvoiceCheckbox: function (){
                $("#show-invoice-fields").on('change', function(ev){

                    invoiceEdit.hideAllFields();
                    $(".choose-customer-typology").hide();
                    if ($(this).is(':checked')){
                        $("#request_invoice").val(1);
                        if ($(".choose-customer-typology").data("can-choose")){
                            $(".choose-customer-typology").show();
                            $('input[type=radio][name=customer_typology]:checked').trigger('change');
                        }else{
                            invoiceEdit.showCompanyFields();
                        }

                    }else{
                        $("#request_invoice").val(0);
                    }
                });
            },

            bindCustomerChoice: function(){
                $('input[type=radio][name=customer_typology]').change(function() {
                    invoiceEdit.hideAllFields();

                    $(".oms-destination-field").show();
                    if (this.value==0){
                        invoiceEdit.showPrivateFields();
                    }else{
                        invoiceEdit.showCompanyFields();
                    }
                });
            },



            checkMandatoryInvoice: function(passed_country) {

                var country = passed_country || config.country;




                if (config.mandatory_invoice.includes(passed_country)){
                    invoiceEdit.setMandatoryInvoice();
                }else{
                    if (country=='IT'){
                        $(".choose-customer-typology").data('can-choose', true);
                    }else{
                        $(".choose-customer-typology").data('can-choose', false);
                    }
                    invoiceEdit.setOptionalInvoice(passed_country);
                    $("#show-invoice-fields").trigger('change');
                }
            }
        }

        invoiceEdit.init();
    };
});
