<?php
/**
 * Created by PhpStorm.
 * User: alberto
 * Date: 07/08/20
 * Time: 15.06
 */

namespace Drop\Oms\Model;

use Drop\Oms\Api\FeAddressesInterface;

class FeAddresses implements FeAddressesInterface
{
    protected $_order;

    public function __construct(
        \Magento\Sales\Model\Order $_order
    )
    {
        $this->_order = $_order;
    }

    public function get($id)
    {
        try {
            $order = $this->_order->load($id);
        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }

        $billing = $order->getBillingAddress();
        $shipping = $order->getShippingAddress();

        try {
            $response = [
                [
                    'type'                     => 'billing',
                    'entity_id'                => $billing->getEntityId(),
                    'lastname'                 => $billing->getLastname(),
                    'firstname'                => $billing->getFirstname(),
                    'country_id'               => $billing->getCountryId(),
                    'street'                   => $billing->getStreet(),
                    'region'                   => $billing->getRegion(),
                    'postcode'                 => $billing->getPostcode(),
                    'city'                     => $billing->getCity(),
                    'company'                  => $billing->getCompany(),
                    'taxvat'                   => $billing->getTaxvat() ?? $billing->getVatId(),
                    'telephone'                => $billing->getTelephone(),
                    'request_invoice'          => $billing->getRequestInvoice(),
                    'customer_typology'        => $billing->getCustomerTypology(),
                    'fiscal_code'              => $billing->getFiscalCode(),
                    'fe_reception_destination' => $billing->getFeReceptionDestination(),
                ],
                [
                    'type'                     => 'shipping',
                    'entity_id'                => $shipping->getEntityId(),
                    'lastname'                 => $shipping->getLastname(),
                    'firstname'                => $shipping->getFirstname(),
                    'country_id'               => $shipping->getCountryId(),
                    'street'                   => $shipping->getStreet(),
                    'region'                   => $shipping->getRegion(),
                    'postcode'                 => $shipping->getPostcode(),
                    'city'                     => $shipping->getCity(),
                    'company'                  => $shipping->getCompany(),
                    'taxvat'                   => $shipping->getTaxvat() ?? $shipping->getVatId(),
                    'telephone'                => $shipping->getTelephone(),
                    'request_invoice'          => $shipping->getRequestInvoice(),
                    'customer_typology'        => $shipping->getCustomerTypology(),
                    'fiscal_code'              => $shipping->getFiscalCode(),
                    'fe_reception_destination' => $shipping->getFeReceptionDestination(),
                ],
            ];
        } catch (\Exception $e) {
            $response = ['error' => $e->getMessage()];
        }

        return $response;
    }
}