define([
    'jquery',
    'Vertex_AddressValidation/js/view/customer/address-form',
    'domReady'
], function($)
{
    return function(config, element) {

        var invoiceEdit = {

            init: function() {
                this.bindCountryEvents();
                this.bindRequestInvoiceCheckbox();
                this.bindCustomerChoice();
                this.checkMandatoryInvoice();
            },

            bindCountryEvents: function(){
                $("#country").on('change', function(ev){
                   var country = $(this).val();
                   invoiceEdit.checkMandatoryInvoice(country);
                });
            },

            bindRequestInvoiceCheckbox: function (){
                $("#show-invoice-fields").on('change', function(ev){

                    invoiceEdit.hideAllFields();
                    $(".choose-customer-typology").hide();
                    if ($(this).is(':checked')){
                        $("#request_invoice").val(1);
                        if ($(".choose-customer-typology").data("can-choose")){
                            $(".choose-customer-typology").show();
                            $('input[type=radio][name=customer_typology]:checked').trigger('change');
                        }else{
                            invoiceEdit.showCompanyFields();
                        }

                     }else{
                        $("#request_invoice").val(0);
                    }
                });
            },

            bindCustomerChoice: function(){
                $('input[type=radio][name=customer_typology]').change(function() {
                    invoiceEdit.hideAllFields();

                    if (this.value==0){
                        invoiceEdit.showPrivateFields();
                    }else{
                        invoiceEdit.showCompanyFields();
                    }
                });
            },

            hideAllFields:function(){
                $(".oms-taxvat-field").hide();
                $(".oms-company-field").hide();
                $(".oms-destination-field").hide();
                $(".oms-fiscal-code-field").hide();
            },

            showPrivateFields: function(){
                $(".oms-destination-field").show();
                $(".oms-fiscal-code-field").show();
            },

            showCompanyFields: function() {
                $(".oms-taxvat-field").show();
                $(".oms-company-field").show();
                if ($("#country").val()=="IT") {
                    $(".oms-destination-field").show();
                }
            },

            checkMandatoryInvoice: function(passed_country) {

                var country = passed_country || config.country;

                $(".choose-customer-typology").data('can-choose', false);

                if (config.mandatory_invoice.includes(country)){
                    invoiceEdit.setMandatoryInvoice();
                }else{
                    if (country=='IT'){
                        $(".choose-customer-typology").data('can-choose', true);
                    }else{
                        $(".choose-customer-typology").data('can-choose', false);
                    }
                    $("#show-invoice-fields").trigger('change');
                    invoiceEdit.setOptionalInvoice(country);
                }
            },

            setMandatoryInvoice: function() {
                $("#request_invoice").val(1);
                $(".oms-invoice").hide();
            },

            setOptionalInvoice: function() {
                $("#request_invoice").val(0);
                $(".oms-invoice").show();
            }
        }

        invoiceEdit.init();
    };
});
