<?php

namespace Drop\NotifyBankTransfer\Setup;

/**
 * Class Uninstall
 */
class Uninstall
{
    /**
     * @var \Magento\Framework\App\Config\Storage\Writer
     */
    protected $writer;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\Storage\Writer $writer
     */
    public function __construct(
        \Magento\Framework\App\Config\Storage\Writer $writer
    ) {
        $this->writer = $writer;
    }

    /**
     * @param  \Magento\Framework\Setup\SchemaSetupInterface   $setup
     * @param  \Magento\Framework\Setup\ModuleContextInterface $context
     * @return void
     */
    public function uninstall(
        \Magento\Framework\Setup\SchemaSetupInterface   $setup,
        \Magento\Framework\Setup\ModuleContextInterface $context
    ) {
        $setup->startSetup();
        $connection = $setup->getConnection();

        $connection->dropTable(
            $connection->getTableName(
                \Drop\NotifyBankTransfer\Model\Database::TABLE_NAME
            )
        );

        $setup->endSetup();

        $this->writer->delete(
            \Drop\NotifyBankTransfer\Helper\Data::CONFIGURATION_CUSTOM_TO_EMAIL
        );

        $this->writer->delete(
            \Drop\NotifyBankTransfer\Helper\Data::CONFIGURATION_TEMPLATE_EACH_DAYS
        );
    }
}
