<?php

namespace Drop\NotifyBankTransfer\Observer\Order;

class PlaceAfter implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Drop\NotifyBankTransfer\Logger\Logger
     */
    private $logger;

    /**
     * @var \Drop\NotifyBankTransfer\Helper\Data
     */
    protected $data;

    /**
     * @var \Drop\NotifyBankTransfer\Helper\Database
     */
    protected $database;

    /**
     * @var \Drop\NotifyBankTransfer\Model\NotifyBankTransferFactory
     */
    private $notifyTransferCollection;

    /**
     * Construct
     *
     * @param \Drop\NotifyBankTransfer\Logger\Logger                    $logger
     * @param \Drop\NotifyBankTransfer\Helper\Data                      $data
     * @param \Drop\NotifyBankTransfer\Model\NotifyBankTransferFactory $notifyTransferCollection
     */
    public function __construct(
        \Drop\NotifyBankTransfer\Logger\Logger                    $logger,
        \Drop\NotifyBankTransfer\Helper\Data                      $data,
        \Drop\NotifyBankTransfer\Helper\Database                  $database,
        \Drop\NotifyBankTransfer\Model\NotifyBankTransferFactory $notifyTransferCollection
    ) {
        $this->logger                   = $logger;
        $this->data                     = $data;
        $this->database                 = $database;
        $this->notifyTransferCollection = $notifyTransferCollection;
    }

    /**
     * {@inheritDoc}
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $incrementId   = $observer->getOrder()->getIncrementId();
        $paymentMethod = $observer->getOrder()->getPayment()->getMethod();
        $email         = $observer->getOrder()->getShippingAddress()->getEmail();

        if (strtolower($paymentMethod) != \Magento\OfflinePayments\Model\Banktransfer::PAYMENT_METHOD_BANKTRANSFER_CODE) {
            return $this;
        }

        $this->logger->info(
            json_encode($this->data->getTemplateEachDays()) . " - " . __METHOD__
        );

        $this->logger->info(
            json_encode($this->database->calculateTimestampCreatedAtFromDay($this->data->getTemplateEachDays())) . " - " . __METHOD__
        );

        try {
            list($timestamp, $timestampDay, $lastTimestampPayload, $queue, $lastNotify) = $this->database->elaborateQueue(
                $this->database->calculateTimestampCreatedAtFromDay(
                    $this->data->getTemplateEachDays()
                )
            );

            $notify = $this->notifyTransferCollection->create();

            $notify->setIncrementId(
                $incrementId
            );

            $notify->setNextTimestampSend(
                $timestamp
            );

            $notify->setNextTimestampSendPayload(
                $lastTimestampPayload
            );

            $notify->setQueueTimestampSend(
                $queue
            );

            $notify->setIsSentLastNotify(
                $lastNotify
            );

            $notify->save();
        } catch (\Exception $e) {
            $this->logger->critical($e);
            throw $e;
        }

        $this->logger->info(
            'Creato record per ordine con bonifico, incrementId: ' . $incrementId . " - " . json_encode([$timestamp, $timestampDay, $lastTimestampPayload, $queue]) . " - " . __METHOD__
        );
    }
}
