<?php

namespace Drop\NotifyBankTransfer\Model\Repository;

class OrderRepository implements \Drop\NotifyBankTransfer\Api\OrderRepositoryInterface
{
    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\CollectionFactory
     */
    protected $orderCollectionFactory;

    /**
     * @var \Drop\NotifyBankTransfer\Helper\Time
     */
    protected $time;

    /**
     * @var \Drop\NotifyBankTransfer\Helper\Data
     */
    protected $data;

    /**
     * @var \Magento\Sales\Model\Order\Config
     */
    protected $orderConfig;

    /**
     * @var \Drop\NotifyBankTransfer\Logger\Logger
     */
    protected $logger;

    /**
     * Construct
     *
     * @param \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory
     * @param \Drop\NotifyBankTransfer\Model\NotifyFactory               $notifyFactory
     * @param \Drop\NotifyBankTransfer\Helper\Time                       $time
     * @param \Drop\NotifyBankTransfer\Helper\Data                       $data
     * @param \Magento\Sales\Model\Order\Config                          $orderConfig
     * @param \Drop\NotifyBankTransfer\Logger\Logger                     $logger
     */
    public function __construct(
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory,
        \Drop\NotifyBankTransfer\Helper\Time                       $time,
        \Drop\NotifyBankTransfer\Helper\Data                       $data,
        \Magento\Sales\Model\Order\Config                          $orderConfig,
        \Drop\NotifyBankTransfer\Logger\Logger                     $logger
    ) {
        $this->orderCollectionFactory = $orderCollectionFactory;
        $this->time                   = $time;
        $this->data                   = $data;
        $this->orderConfig            = $orderConfig;
        $this->logger                 = $logger;
    }

    /**
     * {@inheritDoc}
     */
    public function getOrdersWithPendingTransferMoney()
    {
        $collection = $this->orderCollectionFactory
            ->create()
            ->addFieldToSelect(
                '*'
            )->addFieldToFilter(
            'state',
            \Magento\Sales\Model\Order::STATE_NEW
        );

        $collection->getSelect()
            ->join(
                ["sop" => "sales_order_payment"],
                'main_table.entity_id = sop.parent_id',
                array('method')
            );

        $collection->getSelect()->join(
            ['dntm' => $collection->getTable(\Drop\NotifyBankTransfer\Model\Database::TABLE_NAME)],
            'main_table.increment_id = dntm.increment_id',
            array(
                'dntm_created_at' => 'dntm.created_at',
                'dntm_updated_at' => 'dntm.updated_at',
            )
        );

        $collection->getSelect()->where(
            new \Zend_Db_Expr(" NOW() >= dntm.next_timestamp_send AND dntm.is_sent_last_notify = 0 AND sop.method = '" . \Magento\OfflinePayments\Model\Banktransfer::PAYMENT_METHOD_BANKTRANSFER_CODE . "' ")
        );

        $collection->setOrder(
            'main_table.created_at',
            'desc'
        );

        $this->logger->info(
            "CRON GIRA"
        );

        /*$this->logger->info(
        $collection->getSelect()
        );*/

        return $collection;
    }
}
