<?php

namespace Drop\NotifyBankTransfer\Model\Config\Source;

/**
 * TemplateEmail dropdown source
 */
class TemplateEmail implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var string
     */
    const DEFAULT_TEMPLATE_EMAIL = 'template_drop_notify_bank_transfer_reminder';

    /**
     * @var \Magento\Email\Model\ResourceModel\Template\CollectionFactory
     */
    protected $customTemplateEmail;

    /**
     * Construct
     *
     * @param \Magento\Email\Model\ResourceModel\Template\CollectionFactory $customTemplateEmail
     */
    public function __construct(
        \Magento\Email\Model\ResourceModel\Template\CollectionFactory $customTemplateEmail
    ) {
        $this->customTemplateEmail = $customTemplateEmail;
    }

    public function toOptionArray()
    {
    	$collection = $this->customTemplateEmail->create();

        $r = [
            array(
                'label' => 'Default Reminder Template',
                'value' => self::DEFAULT_TEMPLATE_EMAIL,
            ),
        ];

        foreach ($collection as $c) {
            $r[] = array(
                'label' => $c->getTemplateCode(),
                'value' => (int) $c->getTemplateId(),
            );
        }

        return $r;
    }
}
