<?php

namespace Drop\NotifyBankTransfer\Helper;

use DateTime;

/**
 * Time class
 */
class Time extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\TimezoneInterface
     */
    protected $time;

    /**
     * @var \Drop\NotifyBankTransfer\Helper\Data
     */
    protected $data;

    /**
     * @var \Drop\NotifyBankTransfer\Logger\Logger
     */
    protected $logger;

    /**
     * @var float
     */
    const ONE_MINUTES_TO_DAY = 0.000694444;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface   $scopeConfig
     * @param \Magento\Framework\App\Helper\Context                $context
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $time
     * @param \Drop\NotifyBankTransfer\Helper\Data                $data
     * @param \Drop\NotifyBankTransfer\Logger\Logger              $logger
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface   $scopeConfig,
        \Magento\Framework\App\Helper\Context                $context,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $time,
        \Drop\NotifyBankTransfer\Helper\Data                $data,
        \Drop\NotifyBankTransfer\Logger\Logger              $logger
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->time        = $time;
        $this->data        = $data;
        $this->logger      = $logger;
        parent::__construct($context);
    }

    /**
     * @param  int   $minutes
     * @return int
     */
    public function convertMinutesToDay($minutes)
    {
        return round(($minutes * self::ONE_MINUTES_TO_DAY));
    }

    /**
     * Get DateTime with local timezone
     *
     * @return string
     */
    public function human()
    {
        return $this->time->date()->format('Y-m-d H:i:s');
    }

    /**
     * Get UTC DateTime
     *
     * @return string
     */
    public function humanUTC()
    {
        return $this->time->convertConfigTimeToUtc(
            $this->time->date()->format('Y-m-d H:i:s')
        );
    }

    /**
     * @return string
     */
    public function addDayFromNow($day)
    {
        $dateTime = new DateTime(
            $this->humanUTC()
        );

        $dateTime = $dateTime->modify('+' . $day . " day");

        return $dateTime->format('Y-m-d H:i:s');
    }
}
