<?php

namespace Drop\NotifyBankTransfer\Helper;

use Exception;
use Magento\Framework\Exception\MailException;

/**
 * Email class
 */
class Email extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\App\State
     */
    protected $state;

    /**
     * @var \Magento\Framework\Mail\Template\TransportBuilder
     */
    protected $transportBuilder;

    /**
     * @var \Drop\NotifyBankTransfer\Helper\Data
     */
    protected $helperData;

    /**
     * Construct
     *
     * @param \Magento\Store\Model\StoreManagerInterface         $storeManager
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\State                       $state
     * @param \Magento\Framework\App\Helper\Context              $context
     * @param \Drop\Email\Model\TransportBuilder                 $transportBuilder
     * @param \Drop\NotifyBankTransfer\Helper\Data               $helperData
     */
    public function __construct(
        \Magento\Store\Model\StoreManagerInterface         $storeManager,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\State                       $state,
        \Magento\Framework\App\Helper\Context              $context,
        \Magento\Framework\Mail\Template\TransportBuilder  $transportBuilder,
        \Drop\NotifyBankTransfer\Helper\Data               $helperData
    ) {
        $this->storeManager     = $storeManager;
        $this->scopeConfig      = $scopeConfig;
        $this->state            = $state;
        $this->transportBuilder = $transportBuilder;
        $this->helperData       = $helperData;
        parent::__construct($context);
    }

    /**
     * @param  int          $day
     * @return int|string
     */
    public function getTemplateEmailByDay($day)
    {
        return $this->helperData->getTemplateEachDays()[$day] ?? \Drop\NotifyBankTransfer\Model\Config\Source\TemplateEmail::DEFAULT_TEMPLATE_EMAIL;
    }

    /**
     * @return void
     */
    public function sendNotify(
        $templateId,
        $data,
        $to
    ) {
        if ($this->state->getAreaCode() == null || $this->state->getAreaCode() == "") {
            $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
        }
        
        $to = array_merge([$to], $this->helperData->getCustomToEmail());

        try {
            $this->transportBuilder
                ->setTemplateIdentifier($templateId)
                ->setTemplateOptions([
                    'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $this->storeManager->getStore()->getId(),
                ])
                ->setTemplateVars($data)
                ->setFrom([
                    'name'  => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifyBankTransfer\Model\Email::FROM . '/name',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'email' => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifyBankTransfer\Model\Email::FROM . '/email',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                ])
                ->addTo($to)
                ->getTransport()
                ->sendMessage();
        } catch (MailException $e) {
            throw new \Exception(
                $e->getMessage()
            );
        } catch (Exception $e) {
            throw new Exception(
                $e->getMessage()
            );
        }
    }
}
