<?php

namespace Drop\NotifyBankTransfer\Helper;

/**
 * Database class
 */
class Database extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Drop\NotifyBankTransfer\Helper\Time
     */
    protected $time;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\Helper\Context              $context
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Helper\Context              $context,
        \Drop\NotifyBankTransfer\Helper\Time               $time
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->time        = $time;
        parent::__construct($context);
    }

    /**
     * @param  array    $initQueue
     * @return string
     */
    public function calculateTimestampCreatedAtFromDay($initQueue)
    {
        $firstQueue = [];
        foreach ($initQueue as $day => $template) {
            $firstQueue[] = array(
                'time' => $this->time->addDayFromNow($day),
                'day'  => $day,
            );
        }

        return json_encode($firstQueue);
    }

    /**
     * @param  array|nullable $queue
     * @param  string         $timestampPayload
     * @return array
     */
    public function elaborateQueue(
        $queue,
        $timestampPayload = null
    ) {
        $queue            = null === $queue ? null : json_decode($queue, true);
        $lastNotify       = null === $queue ? 1 : count($queue) == 0 ? 1 : 0;
        $timestampPayload = null === $timestampPayload || 1 == $lastNotify ? null : json_decode($timestampPayload, true);

        if (null == $queue) {
            return array(
                $timestampPayload['time'],
                $timestampPayload['day'],
                null === $timestampPayload ? null : json_encode($timestampPayload),
                null,
                $lastNotify,
            );
        }

        $queue            = array_reverse($queue);
        $timestampPayload = array_pop($queue);

        $timestamp    = $timestampPayload['time'];
        $timestampDay = $timestampPayload['day'];

        $timestampPayload = json_encode($timestampPayload);
        $queue            = count($queue) > 0 ? json_encode(array_reverse($queue)) : null;

        return array(
            $timestamp,
            $timestampDay,
            $timestampPayload,
            $queue,
            $lastNotify,
        );
    }
}
