<?php

namespace Drop\NotifyBankTransfer\Console\Command;

use Exception;

/**
 * NotifyPendingTransferMoney class
 */
class NotifyPendingTransferMoney extends \Symfony\Component\Console\Command\Command
{
    /**
     * @var \Drop\NotifyBankTransfer\Model\RunCheckPendingTransferMoney
     */
    protected $runCheckPendingTransferMoney;

    /**
     * @var \Magento\Framework\App\State
     */
    protected $state;

    /**
     * Construct
     *
     * @param \Drop\NotifyBankTransfer\Model\RunCheckPendingTransferMoney $runCheckPendingTransferMoney
     * @param \Magento\Framework\App\State                                 $state
     */
    public function __construct(
        \Drop\NotifyBankTransfer\Model\RunCheckPendingTransferMoney $runCheckPendingTransferMoney,
        \Magento\Framework\App\State                                 $state
    ) {
        $this->runCheckPendingTransferMoney = $runCheckPendingTransferMoney;
        $this->state                        = $state;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName('drop:notify:pending-transfer');
        $this->setDescription('');

        parent::configure();
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(
        \Symfony\Component\Console\Input\InputInterface   $input,
        \Symfony\Component\Console\Output\OutputInterface $output
    ) {
        try {
            $this->state->setAreaCode('frontend');
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            $this->logger->critical($e);
            throw $e;
        }

        $this->runCheckPendingTransferMoney->run();
    }
}
