<?php

namespace Drop\NotifyBankTransfer\Block\Adminhtml\Form\Field;

/**
 * TemplateEmail class
 */
class TemplateEmail extends \Magento\Framework\View\Element\Html\Select
{
    protected $_templateEmail;

    /**
     * Construct
     *
     * @param \Magento\Framework\View\Element\Context $context
     * @param \Drop\NotifyBankTransfer\Model\Config\Source\TemplateEmail $templateEmail
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Context $context,
        \Drop\NotifyBankTransfer\Model\Config\Source\TemplateEmail $templateEmail,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->_templateEmail = $templateEmail;
    }

    /**
     * @return \Drop\NotifyBankTransfer\Block\Adminhtml\Form\Field\TemplateEmail
     */
    public function setInputName($value)
    {
        return $this->setName($value);
    }

    /**
     * @return mixed
     */
    public function _toHtml()
    {
        if (!$this->getOptions()) {
            $attributes = $this->_templateEmail->toOptionArray();

            foreach ($attributes as $attribute) {
                $this->addOption($attribute['value'], $attribute['label']);
            }
        }

        return parent::_toHtml();
    }
}