<?php

namespace Drop\NotifyBankTransfer\Setup;

/**
 * Class InstallSchema
 */
class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{
    /**
     * {@inheritDoc}
     */
    public function install(
        \Magento\Framework\Setup\SchemaSetupInterface   $setup,
        \Magento\Framework\Setup\ModuleContextInterface $context
    ) {
        $installer = $setup;
        $installer->startSetup();

        $installer->getConnection()->createTable(
            $installer->getConnection()->newTable(
                $installer->getTable(
                    \Drop\NotifyBankTransfer\Model\Database::TABLE_NAME
                )
            )->addColumn(
                \Drop\NotifyBankTransfer\Model\Database::PRIMARY_KEY,
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'Primary key for the Table'
            )->addColumn(
                'increment_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'Sent Notify For Increment Id'
            )->addColumn(
                'next_timestamp_send',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                'Next Timestamp Send'
            )->addColumn(
                'next_timestamp_send_payload',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Next Timestamp Send Payload'
            )->addColumn(
                'queue_timestamp_send',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                '2G',
                ['nullable' => true],
                'Queue Timestamp Send'
            )->addColumn(
                'is_sent_last_notify',
                \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                null,
                ['nullable' => false, 'default' => 0],
                'Is Sent Last Notify'
            )->addColumn(
                'created_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                'Created at'
            )->addColumn(
                'updated_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
                'Updated at'
            )->setComment(
                'This is master table of drop notify module'
            )
        );

        $installer->endSetup();
    }
}
