<?php

namespace Drop\NotifyBankTransfer\Helper;

/**
 * Data class
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var string
     */
    const CONFIGURATION_CUSTOM_TO_EMAIL = 'drop_notify_bank_transfer/configuration/custom_to_email';

    /**
     * @var string
     */
    const CONFIGURATION_TEMPLATE_EACH_DAYS = 'drop_notify_bank_transfer/configuration/template_each_days';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\Helper\Context              $context
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Helper\Context              $context
    ) {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    /**
     * @return string
     */
    private function getConfig($configPath)
    {
        return $this->scopeConfig->getValue(
            $configPath,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getCustomToEmail()
    {
        $emails = [];

        $currentEmails = explode(',', $this->getConfig(self::CONFIGURATION_CUSTOM_TO_EMAIL));

        if (count($currentEmails) <= 0) {
            return $emails;
        }

        foreach ($currentEmails as $d) {
            $d = trim($d);
            $d = strtolower($d);

            if (empty($d)) {
                continue;
            }

            $emails[] = $d;
        }

        return $emails;
    }

    /**
     * @return array
     */
    private function defaultIfNotSet()
    {
        return [3 => \Drop\NotifyBankTransfer\Model\Config\Source\TemplateEmail::DEFAULT_TEMPLATE_EMAIL];
    }

    /**
     * @return int
     */
    public function getTemplateEachDays()
    {
        $ru = [];

        $e = $this->getConfig(
            self::CONFIGURATION_TEMPLATE_EACH_DAYS
        );

        $edc = json_decode($e);

        if (count($edc) <= 0) {
            return $this->defaultIfNotSet();
        }

        foreach (json_decode($e) as $r) {
            $ru[$r->day] = is_numeric($r->template_email_attribute) ? (int) $r->template_email_attribute : $r->template_email_attribute;
        }

        ksort($ru);

        return $ru;
    }
}
