<?php

namespace Drop\NotifyBankTransfer\Block\Adminhtml\Form\Field;

/**
 * AdditionalDay class
 */
class AdditionalDay extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray
{
    /**
     * @var \Drop\NotifyBankTransfer\Block\Adminhtml\Form\Field\TemplateEmail
     */
    protected $_templateEmail;

    /**
     * @return \Drop\NotifyBankTransfer\Block\Adminhtml\Form\Field\TemplateEmail
     */
    protected function _getActivationRenderer()
    {
        if ( ! $this->_templateEmail) {
            $this->_templateEmail = $this->getLayout()->createBlock(
                '\Drop\NotifyBankTransfer\Block\Adminhtml\Form\Field\TemplateEmail',
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }

        return $this->_templateEmail;
    }

    /**
     * @return void
     */
    protected function _prepareToRender()
    {
        $this->addColumn('day', ['label' => __('Day'), 'class' => 'required-entry validate-greater-than-zero']);
        $this->addColumn(
            'template_email_attribute',
            [
                'label'    => __('Template email'),
                'renderer' => $this->_getActivationRenderer(),
            ]
        );

        $this->_addAfter       = false;
        $this->_addButtonLabel = __('Add');
    }

    /**
     * @param  \Magento\Framework\DataObject $row
     * @return void
     */
    protected function _prepareArrayRow(\Magento\Framework\DataObject $row)
    {
        $options         = [];
        $customAttribute = $row->getData('template_email_attribute');

        $key           = 'option_' . $this->_getActivationRenderer()->calcOptionHash($customAttribute);
        $options[$key] = 'selected="selected"';
        $row->setData('option_extra_attrs', $options);
    }
}
