<?php

namespace Drop\NotifySecurityAdmin\Helper;

use Magento\Framework\Exception\MailException;

/**
 * Email class
 */
class Email extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\App\State
     */
    protected $state;

    /**
     * @var \Magento\Framework\Mail\Template\TransportBuilder
     */
    protected $transportBuilder;

    /**
     * @var \Drop\NotifySecurityAdmin\Helper\Email
     */
    protected $helperData;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\State                       $state
     * @param \Magento\Framework\App\Helper\Context              $context
     * @param \Magento\Framework\Mail\Template\TransportBuilder                 $transportBuilder
     * @param \Drop\NotifySecurityAdmin\Helper\Data              $helperData
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\State $state,
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Drop\NotifySecurityAdmin\Helper\Data $helperData
    ) {
        $this->scopeConfig      = $scopeConfig;
        $this->state            = $state;
        $this->transportBuilder = $transportBuilder;
        $this->helperData       = $helperData;
        parent::__construct($context);
    }

    public function sendNotify($payload)
    {
        try {
            if ($this->state->getAreaCode() == null || $this->state->getAreaCode() == "") {
                $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
            }

            $this->transportBuilder
                ->setTemplateIdentifier(
                    \Drop\NotifySecurityAdmin\Model\Email::TEMPLATE_ID
                )
                ->setTemplateOptions([
                    'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => 1,
                ])
                ->setTemplateVars(
                    $payload
                )
                ->setFrom([
                    'name'  => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifySecurityAdmin\Model\Email::FROM . '/name',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'email' => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifySecurityAdmin\Model\Email::FROM . '/email',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                ])
                ->addTo(
                    $this->helperData->getTo()
                )
                ->getTransport()
                ->sendMessage();

        } catch (MailException $e) {
            throw new \Exception($e->getMessage());
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }
}
