<?php

namespace Drop\NotifySecurityAdmin\Plugin\User;

use Closure;
use Exception;

/**
 * Save class
 */
class Save
{
    /**
     * @var \Drop\NotifySecurityAdmin\Helper\Data
     */
    protected $helper;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    protected $request;

    /**
     * @var \Drop\NotifySecurityAdmin\Helper
     */
    protected $emailHelper;

    /**
     * @var \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress
     */
    protected $remoteAddress;

    /**
     * @var \Magento\Framework\App\Response\RedirectInterface
     */
    protected $redirect;

    /**
     * @var \Magento\Framework\Message\ManagerInterface
     */
    protected $messageManager;

    /**
     * @var \Magento\Backend\Model\Session
     */
    protected $backendSession;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * Construct
     *
     * @param \Drop\NotifySecurityAdmin\Helper\Data                $helper
     * @param \Magento\Framework\App\RequestInterface              $request
     * @param \Drop\NotifySecurityAdmin\Helper\Email               $emailHelper
     * @param \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress
     * @param \Magento\Framework\App\Response\RedirectInterface    $redirect
     * @param \Magento\Backend\Model\View\Result\RedirectFactory   $resultRedirectFactory
     * @param \Magento\Framework\Message\ManagerInterface          $messageManager
     * @param \Magento\Backend\Model\Session                       $backendSession
     * @param \Psr\Log\LoggerInterface              $logger
     */
    public function __construct(
        \Drop\NotifySecurityAdmin\Helper\Data $helper,
        \Magento\Framework\App\RequestInterface $request,
        \Drop\NotifySecurityAdmin\Helper\Email $emailHelper,
        \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress,
        \Magento\Framework\App\Response\RedirectInterface $redirect,
        \Magento\Backend\Model\View\Result\RedirectFactory $resultRedirectFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Backend\Model\Session $backendSession,
        \Psr\Log\LoggerInterface $logger
    ) {
        $this->helper                = $helper;
        $this->request               = $request;
        $this->emailHelper           = $emailHelper;
        $this->remoteAddress         = $remoteAddress;
        $this->redirect              = $redirect;
        $this->resultRedirectFactory = $resultRedirectFactory;
        $this->messageManager        = $messageManager;
        $this->backendSession        = $backendSession;
        $this->logger                = $logger;
    }

    /**
     * Hook around
     *
     * @param  Magento\User\Controller\Adminhtml\User\Save $subjet
     * @param  Closure                                    $next
     * @return mixed
     */
    public function aroundExecute(
        \Magento\User\Controller\Adminhtml\User\Save $subjet,
        Closure $next
    ) {
        $payload = $this->request->getPostValue();

        if ($this->helper->getDomainList($payload['email'])) {
            $this->messageManager->addErrorMessage(
                'Impossibile creare l\'utente - Dominio non permesso!'
            );
            return $this->redirectToEdit($payload);
        }

        try {
            $this->emailHelper->sendNotify([
                'username' => $payload['username'],
                'email'    => $payload['email'],
                'ip'       => $this->remoteAddress->getRemoteAddress(),
                'refer'    => $this->redirect->getRefererUrl(),
            ]);
        } catch (Exception $e) {
            $this->logger->error($e->getMessage());
            throw new Exception($e->getMessage());
        }

        return $next();
    }

    /**
     * @param \Magento\User\Model\User $model
     * @param array $data
     * @return void
     */
    private function redirectToEdit(array $data)
    {
        $this->backendSession->setUserData($data);

        $resultRedirect = $this->resultRedirectFactory->create();
        $resultRedirect->setUrl(
            $this->redirect->getRefererUrl()
        );
        return $resultRedirect;
    }
}
