<?php

namespace Drop\NotifySecurityAdmin\Helper;

/**
 * Data class
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Authorization\Model\RoleFactory
     */
    protected $roleFactory;

    /**
     * Construct
     * @param \Magento\Framework\App\Config\ScopeConfigInterface                $scopeConfig
     * @param \Magento\Framework\App\Helper\Context                             $context
     * @param \Magento\Authorization\Model\RoleFactory $roleCollectionFactory
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Authorization\Model\RoleFactory $roleFactory
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->roleFactory = $roleFactory;
        parent::__construct($context);
    }

    /**
     * @param  string $configPath
     * @return string
     */
    private function getConfig($configPath)
    {
        return $this->scopeConfig->getValue(
            $configPath,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getTo()
    {
        return trim(
            $this->getConfig(
                'dropnotifysecurityadmin/configuration/custom_to_email'
            )
        );
    }

    /**
     * @return boolean|array
     */
    public function getDomainList($domainName = false)
    {
        $domains = [];

        $currentDomains = explode(',', $this->getConfig("dropnotifysecurityadmin/configuration/domain"));

        if (count($currentDomains) <= 0) {
            return $domains;
        }

        foreach ($currentDomains as $d) {
            $d = trim($d);
            $d = strtolower($d);

            if (empty($d)) {
                continue;
            }

            $domains[] = $d;
        }

        if ($domainName !== false) {
            return in_array(
                explode('@', strtolower($domainName))[1],
                $domains
            );
        }

        return $domains;
    }

    /**
     * @return boolean
     * @deprecated
     */
    public function isRoleAdmin($signUpRoleId)
    {
        $signUpRoleId = $signUpRoleId[0];

        try {
            $roleRequested = $this->roleFactory->create()->load(
                $signUpRoleId
            );
        } catch (\Exception $e) {
            $roleRequested = null;
        }

        if (is_null($roleRequested)) {
            return false;
        }

        return (int) $roleRequested->getRoleId() === \Drop\NotifySecurityAdmin\Model\Data::DEFAULT_ROLE_ADMIN_ID;
    }
}
