<?php

namespace Drop\NotifyRule\Helper;

use Exception;
use Magento\Framework\Exception\MailException;

/**
 * Email class
 */
class Email extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\App\State
     */
    protected $state;

    /**
     * @var \Drop\Email\Model\TransportBuilder
     */
    protected $transportBuilder;

    /**
     * @var \Drop\NotifyRule\Helper\Data
     */
    protected $helperData;

    /**
     * @var \Drop\NotifyRule\Logger\Logger
     */
    protected $logger;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\State                       $state
     * @param \Magento\Framework\App\Helper\Context              $context
     * @param \Drop\Email\Model\TransportBuilder                 $transportBuilder
     * @param \Drop\NotifyRule\Helper\Data                       $helperData
     * @param \Drop\NotifyRule\Logger\Logger                     $logger
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\State                       $state,
        \Magento\Framework\App\Helper\Context              $context,
        \Magento\Framework\Mail\Template\TransportBuilder  $transportBuilder,
        \Drop\NotifyRule\Helper\Data                       $helperData,
        \Drop\NotifyRule\Logger\Logger                     $logger
    ) {
        $this->scopeConfig      = $scopeConfig;
        $this->state            = $state;
        $this->transportBuilder = $transportBuilder;
        $this->helperData       = $helperData;
        $this->logger           = $logger;
        parent::__construct($context);
    }

    /**
     * @param  array  $data
     * @param  bool  $onlyDev
     * @param  string $templateId
     * @return bool
     */
    public function sendNotify(
        $data,
        $onlyDev = false,
        $templateId = 'template_notify_magento_rule'
    ) {
        try {
            if ($this->state->getAreaCode() == null || $this->state->getAreaCode() == "") {
                $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
            }

            $to = $onlyDev ? \Drop\NotifyRule\Model\Email::EMAIL_THROW : $this->helperData->getCustomToEmail();

            $this->transportBuilder
                ->setTemplateIdentifier(
                    $templateId
                )
                ->setTemplateOptions([
                    'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => 1,
                ])
                ->setTemplateVars(
                    $data
                )
                ->setFrom([
                    'name'  => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifyRule\Model\Email::FROM . '/name',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'email' => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifyRule\Model\Email::FROM . '/email',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                ])
                ->addTo(
                    $to
                )
                ->getTransport()
                ->sendMessage();
        }catch (MailException $e) {
            $this->logger->critical($e);
            throw $e;
        } catch (Exception $e) {
            $this->logger->critical($e);
            throw $e;
        }

        return 1;
    }
}
