<?php

namespace Drop\NotifyRule\Plugin\Model\Indexer;

use Drop\NotifyRule\Helper\Database;

/**
 * AroundFullRuleReindex class
 */
class AroundFullRuleReindex
{
    /**
     * @var \Drop\NotifyRule\Helper\Database
     */
    protected $_database;

    /**
     * @var \Drop\NotifyRule\Model\NotifyRuleFactory
     */
    protected $_notifyRuleFactory;

    /**
     * @var \Drop\NotifyRule\Helper\Serialize
     */
    protected $_serialized;

    /**
     * @var \Drop\NotifyRule\Logger\Logger
     */
    protected $_logger;

    public function __construct(
        \Drop\NotifyRule\Helper\Database         $database,
        \Drop\NotifyRule\Model\NotifyRuleFactory $notifyRuleFactory,
        \Drop\NotifyRule\Helper\Serialize        $serialized,
        \Drop\NotifyRule\Logger\Logger           $logger
    ) {
        $this->_database          = $database;
        $this->_notifyRuleFactory = $notifyRuleFactory;
        $this->_serialized        = $serialized;
        $this->_logger            = $logger;
    }

    /**
     * @return void
     */
    public function prepareBefore()
    {
        if ($this->_notifyRuleFactory->create()->getCollection()->getSize() > 0) {
            return;
        }

        $catalogRuleProduct = $this->_serialized->serialize(
            $this->_database->getCatalogRuleProduct()
        );

        $notify = $this->_notifyRuleFactory->create();

        $notify->setLastPayloadAfterReindex(
            $catalogRuleProduct
        );

        $notify->save();

        $this->_logger->info('Creato payload d\'avvio ' . __METHOD__);
    }

    /**
     * @return void
     */
    public function prepareAfter()
    {
        $catalogRuleProductBeforeReindex = $this->_serialized->unserialize(
            $this->_notifyRuleFactory->create()->getCollection()->getLastItem()->getLastPayloadAfterReindex()
        );

        $catalogRuleProductAfterReindex = $this->_database->getCatalogRuleProduct();

        $this->_database->prepareDataForReport(
            $catalogRuleProductBeforeReindex,
            $catalogRuleProductAfterReindex
        );
    }

    /**
     * @return void
     */
    public function beforeReindexFull()
    {
        $this->prepareBefore();
    }

    /**
     * @return void
     */
    public function afterReindexFull()
    {
        $this->prepareAfter();
    }
}
