<?php

namespace Drop\NotifyRule\Model;

/**
 * NotifyRule class
 */
class NotifyRule extends \Magento\Framework\Model\AbstractModel implements \Magento\Framework\DataObject\IdentityInterface
{
    const CACHE_TAG = 'drop_notify_rule';

    protected $_cacheTag = 'drop_notify_rule';

    protected $_eventPrefix = 'drop_notify_rule';

    public function _construct()
    {
        $this->_init(
            'Drop\NotifyRule\Model\ResourceModel\NotifyRule'
        );
    }

    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    public function getDefaultValues()
    {
        $values = [];

        return $values;
    }
}
