<?php

namespace Drop\NotifyRule\Helper;

/**
 * Website class
 */
class Website extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Store\Api\WebsiteRepositoryInterface
     */
    protected $_websiteRepository;

    /**
     * @param \Magento\Framework\App\Helper\Context           $context           
     * @param \Magento\Store\Api\WebsiteRepositoryInterface $websiteRepository 
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Api\WebsiteRepositoryInterface $websiteRepository
    ) {
        parent::__construct($context);
        $this->_websiteRepository = $websiteRepository;
    }

    /**
     * @param  array   $websiteIds
     * @return array
     */
    public function getWebsiteName($websiteIds)
    {
        $response = [];

        if (empty($websiteIds)) {
            return $response;
        }

        if(is_string($websiteIds)){
            $websiteIds = explode(',', $websiteIds);
        }

        foreach ($websiteIds as $id) {
            try {
                $code = ($this->_websiteRepository->getById($id))->getName();
            } catch (\Exception $e) {
                continue;
            }

            $response[] = $code;
        }

        return $response;
    }
}
