<?php

namespace Drop\NotifyRule\Helper;

use DateTime;

/**
 * Time class
 */
class Time extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\TimezoneInterface
     */
    protected $time;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface   $scopeConfig
     * @param \Magento\Framework\App\Helper\Context                $context
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $time
     * @param \Drop\NotifyRule\Helper\Data                         $data
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface   $scopeConfig,
        \Magento\Framework\App\Helper\Context                $context,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $time
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->time        = $time;
        parent::__construct($context);
    }

    /**
     * Get DateTime
     *
     * @return string
     */
    public function humanUTC()
    {
        return $this->time->convertConfigTimeToUtc(
            $this->human()
        );
    }

    /**
     * Get UTC DateTime
     *
     * @return string
     */
    public function human()
    {
        return $this->time->date()->format('Y-m-d H:i:s');
    }
}
