<?php

namespace Drop\NotifyRule\Helper;

/**
 * Customer class
 */
class Customer extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Customer\Api\GroupRepositoryInterface
     */
    protected $_groupRepository;

    /**
     * @param \Magento\Framework\App\Helper\Context           $context           
     * @param \Magento\Customer\Api\GroupRepositoryInterface $groupRepository 
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Customer\Api\GroupRepositoryInterface $groupRepository
    ) {
        parent::__construct($context);
        $this->_groupRepository = $groupRepository;
    }

    /**
     * @param  array   $groupIds
     * @return array
     */
    public function getGroupName($groupIds)
    {
        $response = [];

        if (empty($groupIds)) {
            return $response;
        }

        if(is_string($groupIds)){
            $groupIds = explode(',', $groupIds);
        }

        foreach ($groupIds as $id) {
            try {
                $code = ($this->_groupRepository->getById($id))->getCode();
            } catch (\Exception $e) {
                continue;
            }

            $response[] = $code;
        }

        return $response;
    }
}
