<?php

namespace Drop\NotifyRule\Setup;

/**
 * Class InstallSchema
 */
class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{
    /**
     * @param  \Magento\Framework\Setup\SchemaSetupInterface   $setup
     * @param  \Magento\Framework\Setup\ModuleContextInterface $context
     * @return void
     */
    public function install(
        \Magento\Framework\Setup\SchemaSetupInterface   $setup,
        \Magento\Framework\Setup\ModuleContextInterface $context
    ) {
        $installer = $setup;
        $installer->startSetup();

        $installer->getConnection()->createTable(
            $installer->getConnection()->newTable(
                $installer->getTable(
                    \Drop\NotifyRule\Model\Database::TABLE_NAME
                )
            )->addColumn(
                \Drop\NotifyRule\Model\Database::PRIMARY_KEY,
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'Primary key for the Table'
            )->addColumn(
                'last_payload_after_reindex',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                '2G',
                ['nullable' => false],
                'Last Payload After Reindex'
            )->addColumn(
                'difference_from_current_payload_and_last',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                '2G',
                ['nullable' => true],
                'Difference From Current Payload And Last'
            )->addColumn(
                'is_email_sent',
                \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                null,
                ['nullable' => false, 'default' => false],
                'Is Email Sent'
            )->addColumn(
                'created_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                'Created at'
            )->addColumn(   
                'updated_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
                'Updated at'
            )->setComment(
                'This is master table of drop notify rule'
            )
        );

        $installer->getConnection()->addIndex(
            $installer->getTable(
                \Drop\NotifyRule\Model\Database::TABLE_NAME
            ),
            $setup->getIdxName(
                $installer->getTable(
                    \Drop\NotifyRule\Model\Database::TABLE_NAME
                ),
                ['last_payload_after_reindex', 'difference_from_current_payload_and_last'],
                \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
            ),
            ['last_payload_after_reindex', 'difference_from_current_payload_and_last'],
            \Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
        );

        $installer->endSetup();
    }
}
