<?php

namespace Drop\NotifyRule\Helper;

/**
 * TLDR class
 */
class TLDR extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @param  array    $rules
     * @return string
     */
    public function buildTldr($rules)
    {
        $tldr     = "";

        foreach ($rules as $k => $v) {
            foreach ($v as $d => $a) {
                foreach ($a['flag'] as $f) {
                    $tldr .= $this->buildStringForRule($a['rule_name'], $a['rule_id'], $f);
                }
            }
        }

        return $tldr;
    }

    /**
     * @param  string   $ruleName
     * @param  int      $ruleId
     * @param  string   $flag
     * @return string
     */
    public function buildStringForRule(
        $ruleName,
        $ruleId,
        $flag
    ) {
        if ("new" == $flag) {
            return "La regola " . $ruleName . " (ID:" . $ruleId . ") &egrave; stata aggiunta in seguito al reindex, dettaglio sotto!<br/><br />";
        }

        if ("pchg" == $flag) {
            return "La regola " . $ruleName . " (ID:" . $ruleId . ") &egrave; applicata a prodotti differenti, dettaglio sotto!<br/><br />";
        }

        if ("wchg" == $flag) {
            return "La regola " . $ruleName . " (ID:" . $ruleId . ") &egrave; applicata a website diversi, dettaglio sotto!<br/><br />";
        }

        if ("ochg" == $flag) {
            return "La regola " . $ruleName . " (ID:" . $ruleId . ") &egrave; applicata a customer group diversi, dettaglio sotto!<br/><br />";
        }

        if ("rmv" == $flag) {
            return "La regola " . $ruleName . " (ID:" . $ruleId . ") &egrave; stata rimossa in seguito al reindex, dettaglio sotto!<br/><br />";
        }
    }
}
