<?php

namespace Drop\NotifyRule\Helper;

/**
 * Serialize class
 */
class Serialize extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\Serialize\SerializerInterface
     */
    protected $_serialized;

    /**
     * @param \Magento\Framework\App\Helper\Context            $context
     * @param \Magento\Framework\Serialize\SerializerInterface $serialized
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context            $context,
        \Magento\Framework\Serialize\SerializerInterface $serialized
    ) {
        $this->_serialized = $serialized;
        parent::__construct($context);
    }

    /**
     * @param  array    $data
     * @return string
     */
    public function serialize($data)
    {
        return $this->_serialized->serialize(
            $data
        );
    }

    /**
     * @param  array    $data
     * @return string
     */
    public function unserialize($data)
    {
        return $this->_serialized->unserialize(
            $data
        );
    }
}
