<?php

namespace Drop\NotifyRule\Helper;

/**
 * Product class
 */
class Product extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    protected $_productRepository;

    /**
     * @var \Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable
     */
    protected $_catalogProductTypeConfigurable;

    /**
     * @param \Magento\Framework\App\Helper\Context                                      $context                        
     * @param \Magento\Catalog\Api\ProductRepositoryInterface                            $productRepository              
     * @param \Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable $catalogProductTypeConfigurable 
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context                                      $context,
        \Magento\Catalog\Api\ProductRepositoryInterface                            $productRepository,
        \Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable $catalogProductTypeConfigurable
    ) {
        parent::__construct($context);
        $this->_productRepository              = $productRepository;
        $this->_catalogProductTypeConfigurable = $catalogProductTypeConfigurable;
    }

    /**
     * @param  array|string $productIds
     * @return array
     */
    public function getSkuFromId($productIds)
    {
        $response                  = [];
        $toAdd                     = [];

        if (empty($productIds)) {
            return $response;
        }

        if (is_string($productIds)) {
            $productIds = explode(',', $productIds);
        }

        foreach ($productIds as $id) {
            try {
                $product = $this->_productRepository->getById($id);

                if ($product->getTypeId() == 'simple') {
                    $configurable = $this->_catalogProductTypeConfigurable->getParentIdsByChild($product->getId());
                }

                //Se il semplice non ha configurabili, ritorno l'id del semplice.
                if (empty($configurable)) {
                    $toAdd[] = $id;
                    continue;
                }

                foreach ($configurable as $cId) {
                    $toAdd[] = $cId;
                }

                continue;
            } catch (\Exception $e) {
                continue;
            }
        }

        $toAdd = array_unique($toAdd);

        foreach ($toAdd as $productId) {
            $product = $this->_productRepository->getById($productId);

            //echo $productId . " => " . $product->getSku() . " => " . $product->getTypeId() . "\n";

            $response[] = $product->getSku();
        }

        return $response;
    }
}
