<?php

namespace Drop\NotifyRule\Helper;

/**
 * Database class
 */
class Database extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $_resource;

    /**
     * @var \Magento\Framework\DB\Adapter\AdapterInterface
     */
    protected $_connection;

    /**
     * @var \Drop\NotifyRule\Helper\ArrayHelper
     */
    protected $_array;

    /**
     * @var \Drop\NotifyRule\Helper\Product
     */
    protected $_product;

    /**
     * @var \Drop\NotifyRule\Helper\BuildEmailBody
     */
    protected $_buildEmailBody;

    /**
     * @var \Drop\NotifyRule\Helper\Email
     */
    protected $_email;

    /**
     * @var \Drop\NotifyRule\Helper\Serialize
     */
    protected $_serialized;

    /**
     * @var \Drop\NotifyRule\Model\NotifyRuleFactory
     */
    protected $_notifyRuleFactory;

    /**
     * @var \Drop\NotifyRule\Logger\Logger
     */
    protected $_logger;

    /**
     * @param \Magento\Framework\App\ResourceConnection $resource
     * @param \Drop\NotifyRule\Helper\ArrayHelper       $array
     * @param \Drop\NotifyRule\Helper\Product           $product
     * @param \Drop\NotifyRule\Helper\BuildEmailBody    $buildEmailBody
     * @param \Drop\NotifyRule\Helper\Email             $email
     * @param \Drop\NotifyRule\Helper\Serialize         $serialized
     * @param \Drop\NotifyRule\Model\NotifyRuleFactory  $notifyRuleFactory
     * @param \Drop\NotifyRule\Logger\Logger            $logger
     */
    public function __construct(
        \Magento\Framework\App\ResourceConnection $resource,
        \Drop\NotifyRule\Helper\ArrayHelper       $array,
        \Drop\NotifyRule\Helper\Product           $product,
        \Drop\NotifyRule\Helper\BuildEmailBody    $buildEmailBody,
        \Drop\NotifyRule\Helper\Email             $email,
        \Drop\NotifyRule\Helper\Serialize         $serialized,
        \Drop\NotifyRule\Model\NotifyRuleFactory  $notifyRuleFactory,
        \Drop\NotifyRule\Logger\Logger            $logger
    ) {
        $this->_resource          = $resource;
        $this->_connection        = $resource->getConnection();
        $this->_array             = $array;
        $this->_product           = $product;
        $this->_buildEmailBody    = $buildEmailBody;
        $this->_email             = $email;
        $this->_serialized        = $serialized;
        $this->_notifyRuleFactory = $notifyRuleFactory;
        $this->_logger            = $logger;
    }

    /**
     * @return array
     */
    public function getCatalogRuleProduct()
    {
        $z = [];

        $crp = $this->_resource->getTableName('catalogrule_product');
        $cr  = $this->_resource->getTableName('catalogrule');

        $results = $this->_connection->fetchAll(
            "SELECT DISTINCT
            ${crp}.rule_id,
            GROUP_CONCAT(DISTINCT ${crp}.website_id) as website_id,
            GROUP_CONCAT(DISTINCT ${crp}.customer_group_id) as customer_group_id,
            GROUP_CONCAT(DISTINCT ${crp}.product_id) as product_ids,
            ${cr}.name as rule_name
            FROM ${crp}
            INNER JOIN ${cr} ON ${crp}.rule_id = ${cr}.rule_id
            GROUP BY ${crp}.rule_id"
        );

        foreach ($results as $k => $v) {
            $z[$v['rule_id']] = $v;
        }

        return $z;
    }

    /**
     * @return void
     */
    public function prepareDataForReport(
        $stmtBeforeReindex,
        $stmtAfterReindex
    ) {
        $newRules      = [];
        $removedRules  = [];
        $editatedRules = [];

        $this->_logger->info("Inizio logica per generare report Drop Notify Rule " . __METHOD__);

        $difference = $this->_array->getDiffencePayloadAfterBeforeReindex(
            $stmtAfterReindex,
            $stmtBeforeReindex
        );

        if (false === $difference) {
            $this->_logger->info("Nessuna differenza trovata, non genero il report " . __METHOD__);
            return null;
        }

        $dirtyRules = $this->getDirtyRules();

        if ( ! empty($dirtyRules)) {
            if ($dirtyRules->getState()) {
                $this->_logger->info("Trovate regole non applicate, non genero il report " . __METHOD__);
                return null;
            }
        }

        return $this->generateReport(
            $difference,
            $stmtAfterReindex
        );
    }

    /**
     * @return void
     */
    public function generateReport(
        $difference,
        $stmtAfterReindex
    ) {
        $emailStrResponse = $this->_buildEmailBody->buildEmail(
            $difference
        );

        $this->_logger->info("Report generato " . json_encode($emailStrResponse) . " " . __METHOD__);

        //Invio report
        try {
            $this->_email->sendNotify([
                'data' => $emailStrResponse,
            ]);

            $notify = $this->_notifyRuleFactory->create()->load(
                $this->_notifyRuleFactory->create()->getCollection()->getLastItem()->getEntityId(),
                'entity_id'
            );

            $notify->setDifferenceFromCurrentPayloadAndLast(
                $this->_serialized->serialize(
                    $difference
                )
            );
        } catch (\Exception $e) {
            $this->_logger->critical($e);
            throw new \Exception($e->getMessage());
        }

        $notify->setIsEmailSent(
            1
        );

        $notify->save();

        $this->_logger->info("Report inviato " . __METHOD__);

        //creo nuova riga con l'ultimo stato delle regole.
        try {
            $notify = $this->_notifyRuleFactory->create();

            $notify->setLastPayloadAfterReindex(
                $this->_serialized->serialize(
                    $stmtAfterReindex
                )
            );
        } catch (\Exception $e) {
            $this->_logger->critical($e);
            throw new \Exception($e->getMessage());
        }

        $notify->save();

        $this->_logger->info("Creato record per successiva interrogazione " . __METHOD__);
    }

    /**
     * @return \Magento\CatalogRule\Model\Flag
     */
    private function getDirtyRules()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->create(\Magento\CatalogRule\Model\Flag::class)
            ->loadSelf()
        ;
    }
}
