<?php

namespace Drop\NotifyRule\Helper;

/**
 * Data class
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var string
     */
    const CONFIGURATION_CUSTOM_TO_EMAIL = 'drop_notify_magento_rule/configuration/custom_to_email';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\Helper\Context              $context
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Helper\Context              $context
    ) {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    /**
     * @param  string $configPath 
     * @return mixed             
     */
    private function getConfig($configPath)
    {
        return $this->scopeConfig->getValue(
            $configPath,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return array
     */
    public function getCustomToEmail()
    {
        $emails = [];

        $currentEmails = explode(',', $this->getConfig(self::CONFIGURATION_CUSTOM_TO_EMAIL));

        if (count($currentEmails) <= 0) {
            return $emails;
        }

        foreach ($currentEmails as $d) {
            $d = trim($d);
            $d = strtolower($d);

            if (empty($d)) {
                continue;
            }

            $emails[] = $d;
        }

        return $emails;
    }
}
