<?php

namespace Drop\NotifyRule\Helper;

/**
 * BuildEmailBody class
 */
class BuildEmailBody extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Drop\NotifyRule\Helper\Time
     */
    protected $_time;

    /**
     * @var \Drop\NotifyRule\Helper\TLDR
     */
    protected $_tldr;

    /**
     * @var \Drop\NotifyRule\Helper\Product
     */
    protected $_product;

    /**
     * @var \Drop\NotifyRule\Helper\Website
     */
    protected $_website;

    /**
     * @var \Drop\NotifyRule\Helper\Customer
     */
    protected $_customer;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Drop\NotifyRule\Helper\Time          $time,
        \Drop\NotifyRule\Helper\TLDR          $tldr,
        \Drop\NotifyRule\Helper\Product       $product,
        \Drop\NotifyRule\Helper\Website       $website,
        \Drop\NotifyRule\Helper\Customer      $customer
    ) {
        $this->_time     = $time;
        $this->_tldr     = $tldr;
        $this->_product  = $product;
        $this->_website  = $website;
        $this->_customer = $customer;
        parent::__construct($context);
    }

    //@todo refactor.
    public function buildEmail(
        $difference
    ) {
        $strOutput = "";

        $strOutput .= "Report inviato (UTC): ";
        $strOutput .= $this->_time->humanUTC() . "<br /><br />";

        if ($tldr = $this->_tldr->buildTldr($difference)) {
            $strOutput .= $tldr;
        }

        foreach ($difference as $s => $k) {
            foreach ($k as $d => $a) {
                $strOutput .= "<h4>REGOLA:</h4>";
                $strOutput .= $a['rule_name'] . " (ID: " . $a['rule_id'] . ")<br /><br />";

                foreach ($a['flag'] as $f) {
                    //per il momento così...

                    $product = $this->_product->getSkuFromId($a['product_ids']);

                    if ('new' == $f) {
                        $strOutput .= "<h4>Prodotti associati alla regola prima del reindex:</h4>";
                        $strOutput .= "Nessuno<br /><br />";
                        $strOutput .= "<h4>Prodotti associati alla regola dopo del reindex: (" . count($product) . " prodotti) </h4>";
                        $strOutput .= join(', ', $product) . "<br /><br />";
                        /*$strOutput .= "<h4>Differenza: (" . count($product) . " prodotti) </h4>";
                        $strOutput .= join(', ', $product) . "<br /><br />";*/
                    }

                    if ('pchg' == $f) {
                        $before = $a['product_ids_before_reindex'];
                        $after = $a['product_ids_after_reindex'];
                        if(is_string($before)){
                            $before = explode(',', $a['product_ids_before_reindex']);
                        }

                        if(is_string($after)){
                            $after = explode(',', $a['product_ids_after_reindex']);
                        }

                        $diffMerged = [];
                        $diff = array_merge(
                            $diffMerged,
                            array_diff($after, $before),
                            array_diff($before, $after)
                        );

                        $pBefore = $this->_product->getSkuFromId($before);
                        $pAfter = $this->_product->getSkuFromId($after);
                        $pAdd = $this->_product->getSkuFromId(
                            array_diff($after, $before)
                        );
                        $pSub = $this->_product->getSkuFromId(
                            array_diff($before, $after)
                        );

                        $strOutput .= "<h4>Prodotti associati alla regola prima del reindex: (" . count($pBefore) . " prodotti) </h4>";
                        $strOutput .= join(', ', $pBefore) . "<br /><br />";
                        $strOutput .= "<h4>Prodotti associati alla regola dopo del reindex: (" . count($pAfter) . " prodotti) </h4>";
                        $strOutput .= join(', ', $pAfter) . "<br /><br />";
                        /*$strOutput .= "<h4>Differenza (aggiunta): (" . count($pAdd) . " prodotti) </h4>";
                        $strOutput .= join(', ', $pAdd) . "<br /><br />";
                        $strOutput .= "<h4>Differenza (rimozione): (" . count($pSub) . " prodotti) </h4>";
                        $strOutput .= join(', ', $pSub) . "<br /><br />";*/
                    }

                    if ('ochg' == $f) {
                        $before = $a['customer_group_id_before_reindex'];
                        $after = $a['customer_group_id_after_reindex'];
                        if(is_string($before)){
                            $before = explode(',', $a['customer_group_id_before_reindex']);
                        }

                        if(is_string($after)){
                            $after = explode(',', $a['customer_group_id_after_reindex']);
                        }

                        $diffMerged = [];
                        $diff = array_merge(
                            $diffMerged,
                            array_diff($after, $before),
                            array_diff($before, $after)
                        );

                        $strOutput .= "<h4>Customer associati alla regola prima del reindex:</h4>";
                        $strOutput .= join(', ', $this->_customer->getGroupName($before)) . "<br /><br />";
                        $strOutput .= "<h4>Customer associati alla regola dopo del reindex:</h4>";
                        $strOutput .= join(', ', $this->_customer->getGroupName($after)) . "<br /><br />";
                        /*$strOutput .= "<h4>Differenza:</h4>";
                        $strOutput .= join(', ', $this->_customer->getGroupName($diff)) . "<br /><br />";*/
                    }

                    if ('wchg' == $f) {
                        $before = $a['website_id_before_reindex'];
                        $after = $a['website_id_after_reindex'];
                        if(is_string($before)){
                            $before = explode(',', $a['website_id_before_reindex']);
                        }

                        if(is_string($after)){
                            $after = explode(',', $a['website_id_after_reindex']);
                        }

                        $diffMerged = [];
                        $diff = array_merge(
                            $diffMerged,
                            array_diff($after, $before),
                            array_diff($before, $after)
                        );

                        $strOutput .= "<h4>Website associati alla regola prima del reindex:</h4>";
                        $strOutput .= join(', ', $this->_website->getWebsiteName($before)) . "<br /><br />";
                        $strOutput .= "<h4>Website associati alla regola dopo del reindex:</h4>";
                        $strOutput .= join(', ', $this->_website->getWebsiteName($after)) . "<br /><br />";
                        /*$strOutput .= "<h4>Differenza:</h4>";
                        $strOutput .= join(', ', $this->_website->getWebsiteName($diff)) . "<br /><br />";*/
                    }

                    if ('rmv' == $f) {
                        $product = $this->_product->getSkuFromId($a['product_ids']);

                        $strOutput .= "<h4>Prodotti associati alla regola prima del reindex: (" . count($product) . " prodotti) </h4>";
                        $strOutput .= join(', ', $product) . "<br /><br />";
                        $strOutput .= "<h4>Prodotti associati alla regola dopo del reindex:</h4>";
                        $strOutput .= "Nessuno<br /><br />";
                        /*$strOutput .= "<h4>Differenza: (" . count($product) . " prodotti) </h4>";
                        $strOutput .= join(', ', $product) . "<br /><br />";*/
                    }
                }
            }
        }

        return $strOutput;
    }
}
