<?php

namespace Drop\NotifyRule\Helper;

/**
 * ArrayHelper class
 */
class ArrayHelper extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var array|nullable
     */
    protected $_difference;

    /**
     * @var \Drop\NotifyRule\Logger\Logger
     */
    protected $_logger;

    /**
     * @var \Drop\NotifyRule\Helper\Serialize
     */
    protected $_serialize;

    public function __construct(
        \Drop\NotifyRule\Logger\Logger    $logger,
        \Drop\NotifyRule\Helper\Serialize $serialize
    ) {
        $this->_difference = [];
        $this->_logger     = $logger;
        $this->_serialize  = $serialize;
    }

    public function getDiffencePayloadAfterBeforeReindex(
        $a1,
        $a2
    ) {
        $existsDifference = false;

        $added   = [];
        $removed = [];
        $changed = [];

        //Added
        foreach ($a1 as $k => $v) {
            //ciclo le regole nuove,
            //verifico la regola esisteva prima del reindex.

            if ( ! ($a2[$k] ?? false)) {
                $v['flag'][]      = 'new';
                $added[]          = $v;
                $existsDifference = true;
            }
        }

        //Removed
        foreach ($a2 as $k => $v) {
            //ciclo le regole vecchie,
            //verifico la regola esiste dopo del reindex.

            if ( ! ($a1[$k] ?? false)) {
                $v['flag'][]      = 'rmv';
                $removed[]        = $v;
                $existsDifference = true;
            }
        }

        //Editated
        //le differenze possono essere a livello di customer group/website e/o prodotti associati:
        foreach ($a1 as $k => $v) {
            //considerato che magento potrebbe rigenerare le regole pur non cambiando alcun paramentro,
            //parso le stringhe come array così da fare il diff dei valori e non delle posizioni

            //Prima ovviamente verifico se ho la regola altrimenti non posso fare il
            //confronto con il vecchio payload.

            if ( ! ($a2[$k] ?? false)) {
                //echo "continue; ID= " . $k;
                continue;
            }

            $foundDifference = false;
            $diffWebsiteBi = [];
            $diffCustomerBi = [];
            $diffProductIdsBi = [];

            //Difference website
            $websiteRuleAfterReindex  = explode(',', $v['website_id']);
            $websiteRuleBeforeReindex = explode(',', $a2[$k]['website_id']);
            $websiteDifference        = array_merge(
                $diffWebsiteBi, 
                array_diff($websiteRuleAfterReindex, $websiteRuleBeforeReindex),
                array_diff($websiteRuleBeforeReindex, $websiteRuleAfterReindex)
            );

            //Customer difference
            $customerRuleAfterReindex  = explode(',', $v['customer_group_id']);
            $customerRuleBeforeReindex = explode(',', $a2[$k]['customer_group_id']);
            $customerDifference        = array_merge(
                $diffCustomerBi, 
                array_diff($customerRuleAfterReindex, $customerRuleBeforeReindex),
                array_diff($customerRuleBeforeReindex, $customerRuleAfterReindex)
            );

            //product difference
            $productIdsRuleAfterReindex  = explode(',', $v['product_ids']);
            $productIdsRuleBeforeReindex = explode(',', $a2[$k]['product_ids']);
            $productIdsDifference        = array_merge(
                $diffProductIdsBi, 
                array_diff($productIdsRuleAfterReindex, $productIdsRuleBeforeReindex),
                array_diff($productIdsRuleBeforeReindex, $productIdsRuleAfterReindex)
            );

            /*print_r([
                $websiteRuleAfterReindex,
                $websiteRuleBeforeReindex,
                $websiteDifference,
                $customerRuleAfterReindex,
                $customerRuleBeforeReindex,
                $customerDifference,
                $productIdsRuleAfterReindex,
                $productIdsRuleBeforeReindex,
                $productIdsDifference
            ]);*/

            if (count($websiteDifference) > 0) {
                $foundDifference                = true;
                $v['flag'][]                    = "wchg";
                $v['website_id_before_reindex'] = $websiteRuleBeforeReindex;
                $v['website_id_after_reindex']  = $websiteRuleAfterReindex;
            }

            if (count($customerDifference) > 0) {
                $foundDifference                       = true;
                $v['flag'][]                           = "ochg";
                $v['customer_group_id_before_reindex'] = $customerRuleBeforeReindex;
                $v['customer_group_id_after_reindex']  = $customerRuleAfterReindex;
            }

            if (count($productIdsDifference) > 0) {
                $foundDifference                 = true;
                $v['flag'][]                     = "pchg";
                $v['product_ids_before_reindex'] = $productIdsRuleBeforeReindex;
                $v['product_ids_after_reindex']  = $productIdsRuleAfterReindex;
            }

            if ($foundDifference) {
                $existsDifference = true;

                $changed[] = $v;
            }
        }

        return false === $existsDifference ? false : [
            $added,
            $removed,
            $changed,
        ];
    }
}
