<?php

namespace Drop\NotifyCron\Model\Config\Source;

/**
 * Cron status dropdown source
 */
class CronStatus implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var string
     */
    const KILLED = 'killed';

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return [
            array(
                'value' => \Magento\Cron\Model\Schedule::STATUS_RUNNING,
                'label' => strtoupper(\Magento\Cron\Model\Schedule::STATUS_RUNNING),
            ),
            array(
                'value' => self::KILLED,
                'label' => strtoupper(self::KILLED),
            ),
            array(
                'value' => \Magento\Cron\Model\Schedule::STATUS_MISSED,
                'label' => strtoupper(\Magento\Cron\Model\Schedule::STATUS_MISSED),
            ),
            array(
                'value' => \Magento\Cron\Model\Schedule::STATUS_ERROR,
                'label' => strtoupper(\Magento\Cron\Model\Schedule::STATUS_ERROR),
            ),
        ];
    }
}
