<?php
namespace Drop\NotifyCron\Block;

use DateTime;
use IntlDateFormatter;

/**
 * Cron list class
 */
class CronList extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Magento\Framework\Stdlib\DateTime\TimezoneInterface
     */
    protected $timezone;

    /**
     * Construct
     *
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $timezone
     * @param \Magento\Framework\View\Element\Template\Context     $context
     * @param array                                                $data
     */
    public function __construct(
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $timezone,
        \Magento\Framework\View\Element\Template\Context     $context,
        array                                                $data = []
    ) {
        $this->timezone = $timezone;
        parent::__construct($context, $data);
    }

    /**
     * Convert datetime from UTC to CEST|CET
     * @param  string
     * @return string
     */
    public function parseDateTime($date)
    {
        return $this->timezone->formatDateTime(
            $date,
            IntlDateFormatter::SHORT,
            IntlDateFormatter::LONG
        );
    }
}
