<?php

namespace Drop\NotifyCron\Setup;

/**
 * Class InstallSchema
 */
class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{
    /**
     * @param  \Magento\Framework\Setup\SchemaSetupInterface   $setup
     * @param  \Magento\Framework\Setup\ModuleContextInterface $context
     * @return void
     */
    public function install(
        \Magento\Framework\Setup\SchemaSetupInterface   $setup,
        \Magento\Framework\Setup\ModuleContextInterface $context
    ) {
        $installer = $setup;
        $installer->startSetup();

        $installer->getConnection()->createTable(
            $installer->getConnection()->newTable(
                $installer->getTable(
                    \Drop\NotifyCron\Model\Database::TABLE_NAME
                )
            )->addColumn(
                \Drop\NotifyCron\Model\Database::PRIMARY_KEY,
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'Primary key for the Table'
            )->addColumn(
                'schedule_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => false, 'unsigned' => true],
                'Schedule Id'
            )->addColumn(
                'next_send_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_DATETIME,
                null,
                ['nullable' => false],
                'next send timestamp'
            )->setComment(
                'This is master table of drop notify module'
            )
        );

        $installer->endSetup();
    }
}
