<?php

namespace Drop\NotifyCron\Helper;

use DateTime;

/**
 * Time class
 */
class Time extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\TimezoneInterface
     */
    protected $time;

    /**
     * @var \Drop\NotifyCron\Helper\Data
     */
    protected $data;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface   $scopeConfig
     * @param \Magento\Framework\App\Helper\Context                $context
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $time
     * @param \Drop\NotifyCron\Helper\Data                         $data
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface   $scopeConfig,
        \Magento\Framework\App\Helper\Context                $context,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $time,
        \Drop\NotifyCron\Helper\Data                         $data
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->time        = $time;
        $this->data        = $data;
        parent::__construct($context);
    }

    /**
     * Get UTC DateTime
     * 
     * @return string
     */
    public function human()
    {
        return $this->time->convertConfigTimeToUtc(
            $this->time->date()->format('Y-m-d H:i:s')
        );
    }

    /**
     * @return string
     */
    public function calculateTo()
    {
        $dateTime = new DateTime(
            $this->human()
        );

        #$dateTime = $dateTime->modify('-' . $this->data->getTimeExceededCron() . " " . $this->data->getTimeType());
        $dateTime = $dateTime->modify('-' . $this->data->getTimeExceededCron() . " " . \Drop\NotifyCron\Model\Config\Source\TimeExceededCron::MEASURE);

        return $dateTime->format('Y-m-d H:i:s');
    }

    /**
     * @return string
     */
    public function calculateNextSendAt()
    {
        $dateTime = new DateTime(
            $this->human()
        );

        $dateTime = $dateTime->modify('+' . $this->data->getDelaySendEmail() . " " . $this->data->getTimeType());

        return $dateTime->format('Y-m-d H:i:s');
    }
}
