<?php

namespace Drop\NotifyCron\Setup;

/**
 * Class Uninstall
 */
class Uninstall
{
    /**
     * @var \Magento\Framework\App\Config\Storage\Writer
     */
    protected $writer;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\Storage\Writer $writer
     */
    public function __construct(
        \Magento\Framework\App\Config\Storage\Writer $writer
    ) {
        $this->writer = $writer;
    }

    /**
     * @param  \Magento\Framework\Setup\SchemaSetupInterface   $setup
     * @param  \Magento\Framework\Setup\ModuleContextInterface $context
     * @return void
     */
    public function uninstall(
        \Magento\Framework\Setup\SchemaSetupInterface   $setup,
        \Magento\Framework\Setup\ModuleContextInterface $context
    ) {
        $setup->startSetup();
        $connection = $setup->getConnection();

        $connection->dropTable(
            $connection->getTableName(
                \Drop\NotifyCron\Model\Database::TABLE_NAME
            )
        );

        $setup->endSetup();

        $this->writer->delete(
            \Drop\NotifyCron\Helper\Data::CONFIGURATION_CUSTOM_TO_EMAIL
        );

        $this->writer->delete(
            \Drop\NotifyCron\Helper\Data::CONFIGURATION_DELAY_SEND_EMAIL
        );

        $this->writer->delete(
            \Drop\NotifyCron\Helper\Data::CONFIGURATION_TIME_TYPE
        );

        $this->writer->delete(
            \Drop\NotifyCron\Helper\Data::CONFIGURATION_TIME_EXCEEDED_CRON
        );

        $this->writer->delete(
            \Drop\NotifyCron\Helper\Data::CONFIGURATION_CRON_STATUS_WATCH
        );
    }
}
