<?php

namespace Drop\NotifyCron\Model\Repository;

class NotifyRepository implements \Drop\NotifyCron\Api\NotifyRepositoryInterface
{
    /**
     * @var \Magento\Cron\Model\ResourceModel\Schedule\CollectionFactory
     */
    protected $scheduleFactory;

    /**
     * @var \Drop\NotifyCron\Model\NotifyFactory
     */
    protected $notifyFactory;

    /**
     * @var \Drop\NotifyCron\Helper\Time
     */
    protected $time;

    /**
     * @var \Drop\NotifyCron\Helper\Data
     */
    protected $data;

    /**
     * Construct
     *
     * @param \Magento\Cron\Model\ResourceModel\Schedule\CollectionFactory $scheduleFactory
     * @param \Drop\NotifyCron\Model\NotifyFactory                         $notifyFactory
     * @param \Drop\NotifyCron\Helper\Time                                 $time
     * @param \Drop\NotifyCron\Helper\Data                                 $data
     */
    public function __construct(
        \Magento\Cron\Model\ResourceModel\Schedule\CollectionFactory $scheduleFactory,
        \Drop\NotifyCron\Model\NotifyFactory                         $notifyFactory,
        \Drop\NotifyCron\Helper\Time                                 $time,
        \Drop\NotifyCron\Helper\Data                                 $data
    ) {
        $this->scheduleFactory = $scheduleFactory;
        $this->notifyFactory   = $notifyFactory;
        $this->time            = $time;
        $this->data            = $data;
    }

    /**
     * {@inheritDoc}
     */
    public function getCronWatched()
    {
        $collection = $this->scheduleFactory->create()
            ->addFieldToFilter('status', ['in' => $this->data->getCronStatusWatch()]);
        $collection->getSelect()->joinLeft(
            ['dnc' => $collection->getTable('drop_notify_cron')],
            'main_table.schedule_id = dnc.schedule_id',
            array(
                'dnc_id'             => 'dnc.entity_id',
                'dnc_schedule_id'    => 'dnc.schedule_id',
                'dnc_next_timestamp' => 'dnc.next_send_at',
            )
        );

        $collection->getSelect()->where(
            new \Zend_Db_Expr("executed_at <= '" . $this->time->calculateTo() . "' OR executed_at IS NULL")
        );

        $collection->getSelect()->where(
            new \Zend_Db_Expr("dnc.next_send_at IS NULL OR '" . $this->time->human() . "' > dnc.next_send_at")
        );

        $collection->setOrder('executed_at', 'DESC');

        //echo $collection->getSelect();

        return $collection;
    }

    /**
     * {@inheritDoc}
     */
    public function updateTimestampNextSend($key)
    {
        $data = $this->notifyFactory->create()->load(
            $key,
            'schedule_id'
        );

        $data->setScheduleId(
            $key
        );

        $data->setNextSendAt(
            $this->time->calculateNextSendAt()
        );

        $data->save();
    }
}
