<?php

namespace Drop\NotifyCron\Model\Config\Source;

/**
 * Time Exceeded Cron dropdown source
 */
class TimeExceededCron implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var string
     */
    const MEASURE = 'MINUTES';

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        $data = [];
        foreach(range(1, 60) as $time){
            $data[] = array(
                'label' => $time . " " .  self::MEASURE,
                'value' => $time,
            );
        }

        return $data;
    }
}
