<?php

namespace Drop\NotifyCron\Helper;

use Exception;
use Magento\Framework\Exception\MailException;

/**
 * Email class
 */
class Email extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var array
     */
    private $_data = [];

    /**
     * @var string
     */
    private $_templateId = '';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Framework\App\State
     */
    protected $state;

    /**
     * @var \Magento\Framework\Mail\Template\TransportBuilder
     */
    protected $transportBuilder;

    /**
     * @var \Drop\NotifyCron\Helper\Data
     */
    protected $helperData;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\State                       $state
     * @param \Magento\Framework\App\Helper\Context              $context
     * @param \Magento\Framework\Mail\Template\TransportBuilder  $transportBuilder
     * @param \Drop\NotifyCron\Helper\Data                       $helperData
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\State                       $state,
        \Magento\Framework\App\Helper\Context              $context,
        \Magento\Framework\Mail\Template\TransportBuilder  $transportBuilder,
        \Drop\NotifyCron\Helper\Data                       $helperData
    ) {
        $this->scopeConfig      = $scopeConfig;
        $this->state            = $state;
        $this->transportBuilder = $transportBuilder;
        $this->helperData       = $helperData;
        parent::__construct($context);
    }

    /**
     * @return void
     */
    public function sendNotify()
    {
        try {
            if ($this->state->getAreaCode() == null || $this->state->getAreaCode() == "") {
                $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
            }

            $this->transportBuilder
                ->setTemplateIdentifier(
                    $this->_templateId
                )
                ->setTemplateOptions([
                    'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => 1,
                ])
                ->setTemplateVars(
                    $this->_data
                )
                ->setFrom([
                    'name'  => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifyCron\Model\Email::FROM . '/name',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                    'email' => $this->scopeConfig->getValue(
                        'trans_email/ident_' . \Drop\NotifyCron\Model\Email::FROM . '/email',
                        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
                    ),
                ])
                ->addTo(
                    $this->helperData->getCustomToEmail()
                )
                ->getTransport()
                ->sendMessage();
        } catch (MailException $e) {
            throw new \Exception(
                $e->getMessage()
            );
        } catch (Exception $e) {
            throw new Exception(
                $e->getMessage()
            );
        }
    }

    /**
     * @param array
     */
    public function setData($data)
    {
        $this->_data = $data;
    }

    /**
     * @param string
     */
    public function setTemplateId($templateId)
    {
        $this->_templateId = $templateId;
    }
}
