<?php

namespace Drop\NotifyCron\Helper;

/**
 * DeveloperMode class
 */
class DeveloperMode extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\App\EnvironmentFactory
     */
    protected $_environment;

    /**
     * @var \Drop\NotifyCron\Helper\Email
     */
    protected $_email;

    /**
     * @var \Drop\NotifyCron\Logger\Logger
     */
    protected $_logger;

    /**
     * @var string
     */
    const SEMAPHORE_BASE_DIR = __DIR__ . "/../";

    /**
     * @var string
     */
    const SEMAPHORE_FILE = 'devmodenotified';

    /**
     * @var string
     */
    const SEMAPHORE_PATH_TO_FILE = self::SEMAPHORE_BASE_DIR . self::SEMAPHORE_FILE;

    /**
     * @var string MINUTES
     */
    const DELAY_NOTIFY = 2;

    /**
     * @param \Magento\Framework\App\EnvironmentFactory $environment
     * @param \Drop\NotifyCron\Helper\Email             $email
     * @param \Drop\NotifyCron\Logger\Logger            $logger
     */
    public function __construct(
        \Magento\Framework\App\EnvironmentFactory $environment,
        \Drop\NotifyCron\Helper\Email             $email,
        \Drop\NotifyCron\Logger\Logger            $logger
    ) {
        $this->_environment = $environment;
        $this->_email       = $email;
        $this->_logger      = $logger;
    }

    /**
     * send notify if site is in developer mode
     *
     * @return void
     */
    public function checkIfIsDeveloperMode()
    {
        if ( ! $this->semaphore() || file_exists(\Magento\Framework\App\ObjectManager\ConfigLoader\Compiled::getFilePath(\Magento\Framework\App\Area::AREA_GLOBAL))) {
            return;
        }

        try {
            $this->_email->setTemplateId(
                'template_notify_developer_mode'
            );

            $this->_email->sendNotify();
        } catch (Exception $e) {
            $this->_logger->critical(
                $e
            );

            throw new Exception(
                $e->getMessage()
            );
        }
    }

    private function semaphore()
    {
        if ( ! file_exists(self::SEMAPHORE_PATH_TO_FILE)) {
            file_put_contents(self::SEMAPHORE_PATH_TO_FILE, null);
            return true;
        }

        $difference = (time() - filemtime(self::SEMAPHORE_PATH_TO_FILE));
        $difference = floor($difference / 60);

        if ($difference >= self::DELAY_NOTIFY) {
            unlink(self::SEMAPHORE_PATH_TO_FILE);
            file_put_contents(self::SEMAPHORE_PATH_TO_FILE, null);
            return true;
        }

        return false;
    }

}
