<?php

namespace Drop\NotifyCron\Helper;

/**
 * Data class
 */
class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var string
     */
    const CONFIGURATION_CUSTOM_TO_EMAIL = 'drop_notify_cron_watch/configuration/custom_to_email';

    /**
     * @var int
     */
    const CONFIGURATION_DELAY_SEND_EMAIL = 'drop_notify_cron_watch/configuration/delay_send_email';

    /**
     * @var string
     */
    const CONFIGURATION_TIME_TYPE = 'drop_notify_cron_watch/configuration/time_type';

    /**
     * @var int
     */
    const CONFIGURATION_TIME_EXCEEDED_CRON = 'drop_notify_cron_watch/configuration/time_exceeded_cron';

    /**
     * @var string
     */
    const CONFIGURATION_CRON_STATUS_WATCH = 'drop_notify_cron_watch/configuration/cron_status_watch';

    /**
     * @var bool
     */
    const CONFIGURATION_NOTIFY_LAST_CRON_STATUS = 'drop_notify_cron_watch/configuration/notify_last_cron_status';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\Helper\Context              $context
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Helper\Context              $context
    ) {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    /**
     * @return string
     */
    private function getConfig($configPath)
    {
        return $this->scopeConfig->getValue(
            $configPath,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @return string
     */
    public function getCustomToEmail()
    {
        return trim(
            $this->getConfig(
                self::CONFIGURATION_CUSTOM_TO_EMAIL
            )
        );
    }

    /**
     * @return int
     */
    public function getDelaySendEmail()
    {
        $delay = trim(
            $this->getConfig(
                self::CONFIGURATION_DELAY_SEND_EMAIL
            )
        );

        return (int) $delay;
    }

    /**
     * @return string
     */
    public function getTimeType()
    {
        $type = trim(
            $this->getConfig(
                self::CONFIGURATION_TIME_TYPE
            )
        );

        return $type;
    }

    /**
     * @return int
     */
    public function getTimeExceededCron()
    {
        $time = trim(
            $this->getConfig(
                self::CONFIGURATION_TIME_EXCEEDED_CRON
            )
        );

        return (int) $time;
    }

    /**
     * @return string
     */
    public function getCronStatusWatch()
    {
        return trim(
            $this->getConfig(
                self::CONFIGURATION_CRON_STATUS_WATCH
            )
        );
    }

    /**
     * @return bool
     */
    public function getNotifyLastCronStatus()
    {
        return trim(
            $this->getConfig(
                self::CONFIGURATION_NOTIFY_LAST_CRON_STATUS
            )
        );
    }
}
