<?php

namespace Drop\NotifyCron\Console\Command;

use Exception;

/**
 * CheckLastCronStatus class
 */
class CheckLastCronStatus extends \Symfony\Component\Console\Command\Command
{
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;

    /**
     * @var \Drop\NotifyCron\Logger\Logger
     */
    private $logger;

    /**
     * @var \Drop\NotifyCron\Helper\Email
     */
    private $email;

    /**
     * @var \Drop\NotifyCron\Helper\Schedule
     */
    private $schedule;

    /**
     * @var \Drop\NotifyCron\Helper\Schedule
     */
    private $data;

    /**
     * @var \Drop\NotifyCron\Model\Repository\NotifyRepository
     */
    private $notifyRepository;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\State                       $state
     * @param \Drop\NotifyCron\Logger\Logger                     $logger
     * @param \Drop\NotifyCron\Helper\Email                      $email
     * @param \Drop\NotifyCron\Helper\Schedule                   $schedule
     * @param \Drop\NotifyCron\Helper\Data                       $data
     * @param \Drop\NotifyCron\Model\Repository\NotifyRepository $notifyRepository
     */
    public function __construct(
        \Magento\Framework\App\State                       $state,
        \Drop\NotifyCron\Logger\Logger                     $logger,
        \Drop\NotifyCron\Helper\Email                      $email,
        \Drop\NotifyCron\Helper\Schedule                   $schedule,
        \Drop\NotifyCron\Helper\Data                       $data,
        \Drop\NotifyCron\Model\Repository\NotifyRepository $notifyRepository
    ) {
        $this->state            = $state;
        $this->logger           = $logger;
        $this->email            = $email;
        $this->schedule         = $schedule;
        $this->data             = $data;
        $this->notifyRepository = $notifyRepository;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName('drop:cron:last');
        $this->setDescription('Check if cron is running');

        parent::configure();
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(
        \Symfony\Component\Console\Input\InputInterface   $input,
        \Symfony\Component\Console\Output\OutputInterface $output
    ) {
        if ( ! $this->data->getNotifyLastCronStatus()) {
            return;
        }

        if ($this->schedule->isCronRun()) {
            return;
        }

        try {
            $this->state->setAreaCode('frontend');
        } catch (\Magento\Framework\Exception\LocalizedException $exception) {
        }

        $this->notifyRepository->updateTimestampNextSend(
            \Drop\NotifyCron\Model\Database::LAST_CRON_STATUS_SCHEDULE_ID
        );

        try {
            $this->email->setTemplateId(
                'template_notify_last_cron_status'
            );

            $this->email->sendNotify();
        } catch (Exception $e) {
            $output->writeln(
                $e->getMessage()
            );

            $this->logger->critical(
                $e
            );

            throw new Exception(
                $e->getMessage()
            );
        }

        $output->writeln(
            '[CHECK LAST CRON STATUS] I cron non stanno girando!'
        );

        $this->logger->error(
            '[CHECK LAST CRON STATUS] I cron non stanno girando!'
        );
    }
}
