<?php

namespace Drop\NotifyCron\Console\Command;

use Exception;

/**
 * CheckCronWatch class
 */
class CheckCronWatch extends \Symfony\Component\Console\Command\Command
{
    /**
     * @var \Drop\NotifyCron\Model\Repository\NotifyRepository
     */
    private $notifyRepository;

    /**
     * @var \Magento\Framework\App\State
     */
    private $state;

    /**
     * @var \Drop\NotifyCron\Logger\Logger
     */
    private $logger;

    /**
     * @var \Drop\NotifyCron\Helper\Time
     */
    private $time;

    /**
     * @var \Drop\NotifyCron\Helper\Email
     */
    private $email;

    /**
     * @var \Drop\NotifyCron\Helper\Data
     */
    private $data;

    /**
     * @var \Drop\NotifyCron\Console\Command\CheckLastCronStatus
     */
    private $lastCronStatus;

    /**
     * Construct
     *
     * @param \Drop\NotifyCron\Model\Repository\NotifyRepository   $notifyRepository
     * @param \Magento\Framework\App\State                         $state
     * @param \Drop\NotifyCron\Logger\Logger                       $logger
     * @param \Drop\NotifyCron\Helper\Time                         $time
     * @param \Drop\NotifyCron\Helper\Email                        $email
     * @param \Drop\NotifyCron\Helper\Data                         $data
     * @param \Drop\NotifyCron\Console\Command\CheckLastCronStatus $lastCronStatus
     */
    public function __construct(
        \Drop\NotifyCron\Model\Repository\NotifyRepository   $notifyRepository,
        \Magento\Framework\App\State                         $state,
        \Drop\NotifyCron\Logger\Logger                       $logger,
        \Drop\NotifyCron\Helper\Time                         $time,
        \Drop\NotifyCron\Helper\Email                        $email,
        \Drop\NotifyCron\Helper\Data                         $data,
        \Drop\NotifyCron\Console\Command\CheckLastCronStatus $lastCronStatus
    ) {
        $this->notifyRepository = $notifyRepository;
        $this->state            = $state;
        $this->logger           = $logger;
        $this->time             = $time;
        $this->email            = $email;
        $this->data             = $data;
        $this->lastCronStatus   = $lastCronStatus;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName('drop:cron:check');
        $this->setDescription('');

        parent::configure();
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(
        \Symfony\Component\Console\Input\InputInterface   $input,
        \Symfony\Component\Console\Output\OutputInterface $output
    ) {
        $this->lastCronStatus->execute(
            $input,
            $output
        );

        try {
            $this->state->setAreaCode('frontend');
        } catch (\Magento\Framework\Exception\LocalizedException $exception) {
        }

        $collection = $this->notifyRepository->getCronWatched();

        if ($collection->getSize() <= 0) {
            return;
        }

        foreach ($collection as $c) {
            $data = $this->notifyRepository->updateTimestampNextSend(
                $c->getScheduleId()
            );
        }

        try {
            $this->email->setData([
                'collection'  => $collection,
                'cron_state'  => $this->data->getCronStatusWatch(),
                'time_exceed' => $this->data->getTimeExceededCron(),
            ]);

            $this->email->setTemplateId(
                'template_notify_cron_to_check'
            );

            $this->email->sendNotify();
        } catch (Exception $e) {
            $output->writeln(
                $e->getMessage()
            );

            $this->logger->critical(
                $e
            );

            throw new Exception(
                $e->getMessage()
            );
        }

        $output->writeln(
            '[CHECK CRON WATCH] cron ' . $this->data->getCronStatusWatch() . " found (UTC) => " . json_encode($collection->toArray())
        );

        $this->logger->info(
            '[CHECK CRON WATCH] cron ' . $this->data->getCronStatusWatch() . " found (UTC) => " . json_encode($collection->toArray())
        );
    }
}
