<?php
    /**
     * Created by PhpStorm.
     * User: Andrea D'Innocenzo
     * Date: 12/02/20
     * Time: 11.43
     */

    namespace Drop\MirasvitEmail\Model\Queue;

    use Magento\Framework\Mail\TemplateInterface;

    class TransportBuilder extends \Mirasvit\Email\Model\Queue\TransportBuilder
    {
        /**
         * Set from
         *
         * @param string $email
         * @param string $name
         *
         * @return $this
         */
        public function setFrom($email, $name = null)
        {

            // fix per compatibilità con vecchi moduli dove veniva passato un array come primo parametro
            // contenente indirizzo email e nome mittente
            if(is_array($email)){
                $arrayEmail = $email;

                // l'array in ingresso potrebbe essere associativo, per sicurezza controllo quali elementi
                // contengono @ in modo da identificare l'indirizzo email (se ne sono più di uno comunque viene preso l'ultimo),
                // il restante (se esistente) è il nome mittente
                foreach ($arrayEmail as $value) {
                    if(strstr($value, "@") !== false){
                        $email = $value;
                        continue;
                    }
                    $name = $value;
                }
            }

            $this->getTemplate()->setFrom($email, $name);

            if (method_exists($this, 'setFromByScope')) {
                $this->setFromByScope('general');
            }

            return $this;
        }
    }