<?php

namespace Drop\MirasvitEmail\Model\Queue;

/**
 * Sender class
 */
class Sender extends \Mirasvit\Email\Model\Queue\Sender
{
    /**
     * @var MailModifierInterface[]
     */
    private $modifiers = [];

    /**
     * @return \Drop\Email\Model\TransportBuilder
     */
    private function getDropTransportBuilder()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Drop\Email\Model\TransportBuilder::class);
    }

    /**
     * @return \Magento\Framework\Registry
     */
    private function getRegistry()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Magento\Framework\Registry::class);
    }

    /**
     * @return \Magento\Store\Model\App\Emulation
     */
    private function getEmulation()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Magento\Store\Model\App\Emulation::class);
    }

    /**
     * @return \Mirasvit\Email\Helper\Data
     */
    private function getHelper()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Mirasvit\Email\Helper\Data::class);
    }

    /**
     * @return \Mirasvit\Email\Model\Config
     */
    private function getConfig()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Mirasvit\Email\Model\Config::class);
    }

    /**
     * @return \Magento\Framework\App\ProductMetadataInterface
     */
    private function getProductMeta()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Magento\Framework\App\ProductMetadataInterface::class);
    }

    /**
     * {@inheritDoc}
     */
    public function send(
        $queue,
        $force = false
    ) {
        if ( ! $this->canSend($queue) && ! $force) {
            return false;
        }

        $dropTransportBuilder = $this->getDropTransportBuilder();

        // register current email queue model instance
        $this->getRegistry()->register(\Mirasvit\Email\Controller\RegistryConstants::CURRENT_QUEUE, $queue, true);

        $this->getEmulation()->startEnvironmentEmulation($queue->getArgs('store_id'), \Magento\Framework\App\Area::AREA_FRONTEND, true);
        $subject = $queue->getMailSubject();
        $this->getEmulation()->stopEnvironmentEmulation();

        $this->getEmulation()->startEnvironmentEmulation($queue->getArgs('store_id'), \Magento\Framework\App\Area::AREA_FRONTEND, true);

        $body = $queue->getMailContent();

        foreach ($this->modifiers as $modifier) {
            $body = $modifier->modifyContent($queue, $body);
        }

        $body = $this->getHelper()->prepareQueueContent($body, $queue);
        $this->getEmulation()->stopEnvironmentEmulation();

        $this->getEmulation()->startEnvironmentEmulation($queue->getArgs('store_id'), \Magento\Framework\App\Area::AREA_FRONTEND, true);

        $recipients = explode(',', $queue->getRecipientEmail());
        if ($this->getConfig()->isSandbox() && ! $queue->getArg('force')) {
            $recipients = explode(',', $this->getConfig()->getSandboxEmail());
        }

        foreach ($recipients as $index => $email) {
            $name = $queue->getRecipientName();
            if (count($recipients) > 1) {
                $name .= ' - ' . ($index + 1);
            }
            unset($recipients[$index]);
            $recipients[$name] = $email;
        }

        //trim spaces and remove all empty items
        $copyTo = array_filter(array_map('trim', explode(',', $queue->getTrigger()->getCopyEmail())));
        foreach ($copyTo as $bcc) {
            $dropTransportBuilder->addBcc($bcc);
        }

        $dropTransportBuilder
            ->setReplyTo($queue->getSenderEmail(), $queue->getSenderName());

        $magentoVersion = $this->getProductMeta()->getVersion();
        if (version_compare($magentoVersion, '2.2.8', '>=')) {
            $dropTransportBuilder->setFrom([
                'name'  => $queue->getSenderName(),
                'email' => $queue->getSenderEmail(),
            ]);
        } else {
            $dropTransportBuilder->setFrom($queue->getSenderEmail(), $queue->getSenderName());
        }

        foreach ($recipients as $name => $email) {
            $dropTransportBuilder->addTo($email, $name);
        }

        $dropTransportBuilder->setTemplateIdentifier(
            'raw_template_mirasvit'
        );

        $dropTransportBuilder->setTemplateVars([
            'data'    => $body,
            'subject' => $subject,
        ]);

        $dropTransportBuilder->setTemplateOptions([
            'area'  => \Magento\Framework\App\Area::AREA_FRONTEND,
            'store' => $queue->getArgs('store_id'),
        ]);

        $transport = $dropTransportBuilder->getTransport();

        $transport->sendMessage();

        $queue->delivery();

        $this->getEmulation()->stopEnvironmentEmulation();

        return true;
    }
}
