<?php

namespace Drop\Taxclass\Model\Config\Source;

class Taxclass implements \Magento\Framework\Option\ArrayInterface
{
    protected $productTaxClassSource;

    /**
     * Taxclass constructor.
     * @param ProductTaxClassSource $productTaxClassSource
     */
    public function __construct(
        \Magento\Tax\Model\TaxClass\Source\Product $productTaxClassSource
    )
    {
        $this->productTaxClassSource = $productTaxClassSource;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => '',
                'label' => '',
            ]
        ];

        $taxClassess = $this->productTaxClassSource->getAllOptions();
        foreach ($taxClassess as $tax) {
            $options[] = [
                'value' => $tax['value'],
                'label' => $tax['label'],
            ];
        }

        return $options;
    }
}